<?php
function system_getlatestpackages(&$content,&$error,$forcefetch=false)
{
    global$datadir;
    $f="$datadir/services/system/packagescache.json";
    if($forcefetch||!file_exists($f))
    {
        if(!system_downloadpackagestocache($content,$error))return false;
        return true;
    }
    $fmtime=filemtime($f);
    if($fmtime+2*7*24*60*60<time())
    {
        if(!system_downloadpackagestocache($content,$error))return false;
        return true;
    }
    $content=[];
    if(!ozreadjson($f,$content,$error))
    {
        return false;
    }
    return true;
}

function system_downloadpackagestocache(&$content,&$error)
{
    global$datadir;
    $d="$datadir/services/system";
    $f="$d/packagescache.json";
    if(!system_fetchpackages($packages,$error))return false;
    $content=[];
    $content["downloadedat"]=mysqldate();
    $content["packages"]=$packages;
    ozmkdir($d,$error);
    ozsavejson($f,$content,$error);
    return true;
}

function system_fetchpackages(&$packages,&$error)
{
    $url="https://repo.ozeki.hu/dists/noble/main/binary-all/Packages";
    $ctx=stream_context_create([
        'http'=>[
            'timeout'=>5,
        ],
    ]);
    $content=file_get_contents($url,false,$ctx);
    if($content===false)
    {
        $error = "Failed to fetch package list from $url.";
        return false;
    }
    $entries=explode("\n\n",$content);
    $packages=[];
    foreach($entries as $entry)
    {
        $lines=explode("\n",$entry);
        $name="";
        $version="";
        foreach($lines as $line)
        {
            if(str_starts_with($line,"Package: "))
            {
                $name=trim(substr($line,strlen("Package: ")));
                continue;
            }
            if(str_starts_with($line,"Version: "))
            {
                $version=trim(substr($line,strlen("Version: ")));
                continue;
            }
            if($name&&$version)break;
        }
        if($name&&$version)
        {
            $packages[$name]=$version;
        }
    }
    return true;
}

if (!function_exists('str_starts_with')) {
    function str_starts_with(string $haystack, string $needle): bool {
        return substr($haystack, 0, strlen($needle)) === $needle;
    }
}
?>