<?php
//*****************************************************************
// File size informatoin
//*****************************************************************
function humanFileSize($size,$unit="") 
{
    if( (!$unit && $size >= 1<<30) || $unit == "GB")
      return number_format($size/(1<<30),2)."GB";
    if( (!$unit && $size >= 1<<20) || $unit == "MB")
      return number_format($size/(1<<20),2)."MB";
    if( (!$unit && $size >= 1<<10) || $unit == "KB")
      return number_format($size/(1<<10),2)."KB";
    return number_format($size)." bytes";
}

//*****************************************************************
// File upload
// 
// saveUploadedFiles
// $encryptionmethod = 'none'|'aes'|'rsa'
//
// out: $uploadedfiledetails
// array (size=2)
//  0 => 
//  array (size=3)
//    'nicename' => string 'test2.txt' (length=9)
//    'size' => int 5
//    'storedname' => string 'registrations/819cbfbca5c177d076bcc5a26c5b28c2/inbox/tmp/uploads_20221030094648/ZAMjr1gJ9h_none' (length=95)
//1 => 
//  array (size=3)
//    'nicename' => string 'test1.txt' (length=9)
//    'size' => int 4
//    'storedname' => string 'registrations/819cbfbca5c177d076bcc5a26c5b28c2/inbox/tmp/uploads_20221030094648/vAv8Oh2jsC_none' (length=95)
//*****************************************************************/
function saveUploadedFiles($destdir, $maxuploadsizeinmb, $encryptionmethod,$encryptionkey, &$uploadedfiledetails, &$error)
{
    global $fileuploaddebug,$debuginfo;

    $storerandomized=true;
    if ($encryptionmethod=="none_keepfilename") 
    {
        $encryptionmethod="none";
        $storerandomized=false;
    }

	if(!isset($_FILES["filestoupload"]))
    {
		return true;
	}

	$countfiles = count($_FILES["filestoupload"]['tmp_name']);
    if($countfiles==0)
    {
		return true;
	}

    if (!ozmkdir($destdir,$errorm))
    {
        $error = "Cannot create destination directory to store files.";
        if ($fileuploaddebug) $error.= " ".$errorm;
        return false;
    }

    if ($fileuploaddebug) $debuginfo.= $countfiles." file(s) are ready to be saved on server.<BR>";

    $uploadedfiledetails = array();
	for ($i = 0; $i < $countfiles; $i++) 
    {
        if ($_FILES["filestoupload"]['tmp_name'][$i]=="") continue;
        if ($fileuploaddebug) $debuginfo.= "Processing uploade file: ".$_FILES["filestoupload"]['tmp_name'][$i];
        if (!isFileSizeAcceptable($i, $maxuploadsizeinmb, $error)) return false;
        if (!encryptUploadItem($i,$encryptedname,strtolower($encryptionmethod),$encryptionkey,$error)) return false;
		if (!saveUploadItem($destdir,$i,$encryptedname,strtolower($encryptionmethod),$storerandomized, $fileinfo, $error)) return false;
        array_push($uploadedfiledetails, $fileinfo);
	}
	return true;
}

function isFileSizeAcceptable($i, $maxuploadsizeinmb, &$error)
{
    $maxuploadsize = $maxuploadsizeinmb * (2 ** 20);
    $file_size = $_FILES["filestoupload"]["size"][$i];
    if ($file_size > ($maxuploadsize)) {
        $nicename = basename($_FILES["filestoupload"]['name'][$i]);
		$error = "The size of '.$nicename.' is too large. Maximum allowed size is ".$maxuploadsizeinmb."Mb";
		return false;
	}
    if (isset($fileuploaddebug) && $fileuploaddebug) $debuginfo.= "The file size is acceptable ($file_size<$maxuploadsize).<BR>";
    return true;
}

function encryptUploadItem($i,&$encryptedname,$encryptionmethod,$encryptionkey,&$error)
{
    global $fileuploaddebug,$debuginfo;
    $nicename = $_FILES["filestoupload"]['tmp_name'][$i];

    if (!file_exists($nicename))
    {
        $error = "Uploaded file does not exist.";
        return false;
    }

    if ($encryptionmethod=='none')
    {
        if ($fileuploaddebug) $debuginfo.="No file encryption required. Returning ".$nicename."<BR>";
        $encryptedname = $nicename;
        return true;
    }
    
    if ($encryptionmethod=='aes')
    {
        if ($encryptionkey==null) 
        {
            global $myaesshared;
            $encryptionkey = $myaesshared;
        }
        $encryptedname = $nicename."_aes";
        $ret = encryptFileAES($encryptionkey, $nicename, $encryptedname, $error);
        if ($fileuploaddebug) $debuginfo.="AES file encryption result: $ret. Returning ".$encryptedname."<BR>";
        unlink($nicename);
        return $ret;
    }

    if ($encryptionmethod=='rsa')
    {
        if ($encryptionkey==null) 
        {
            global $mypublickey;
            $encryptionkey = $mypublickey;
        }
        $encryptedname = $nicename."_rsa";
        $ret = encryptFileRSAAES($encryptionkey, $nicename, $encryptedname, $error);
        if ($fileuploaddebug) $debuginfo.="RSA file encryption result: $ret. Returning ".$encryptedname."<BR>";
        unlink($nicename);
        return $ret;
    }

    $error = "Invalid encryption method.";
    return false;
}


function saveUploadItem($destdir,$i,$encryptedname,$encryptionmethod,$storerandomized,&$fileinfo, &$error)
{
    global $fileuploaddebug,$debuginfo,$datadir;

    $nicename = $_FILES["filestoupload"]['name'][$i];
    $sizeinbytes = $_FILES["filestoupload"]["size"][$i];
    $storedname = generateStoredName($destdir, $nicename, $storerandomized);
	$dest_path = $datadir . "/" . $storedname;
	$src_path =  $encryptedname;
	
    if ($nicename === "") 
    {
        $error = "Cannot use an empty filename for upload";
        return false;
    }

    if ($encryptionmethod!='none')
    {
        $dest_path = $dest_path."_".$encryptionmethod;
    }

    if ($fileuploaddebug) $debuginfo.="Copying file with size ".humanFileSize($sizeinbytes)." from ".$src_path." to ".$dest_path."<BR>";

    if (!saveUploadedFile($dest_path, $src_path, $error)) {
        $error = "Cannot move uploaded file to destination folder. ".$error;
        return false;
    }
            
    $encryptedfilename = ($encryptionmethod!="none") ? $storedname."_".$encryptionmethod: $storedname;
    $fileinfo = array("nicename" => $nicename, "size" => $sizeinbytes, "storedname" => $encryptedfilename);
    return true;
}


function generateStoredName($destdir, $nicename, $storerandomized)
{
    global $datadir;
    if ($storerandomized) return substr($destdir, strlen($datadir)+1)."/".ozrndstr();
    return substr($destdir, strlen($datadir)+1)."/".$nicename;
}

function saveUploadedFile($file_dest, $file_src, &$error)
{
    global $fileuploaddebug,$debuginfo;
    if ($fileuploaddebug) $debuginfo.="File copy request from ".$file_src." to ".$file_dest."<BR>";

	if (!file_exists($file_src)) {
		$error = "Source file does not exist";
		return false;
	}

    if (file_exists($file_dest)) {
		$error = "Dest file alredy exists";
		return false;
	}

    $dir = dirname($file_dest);
    if (!ozmkdir($dir,$error))
    {
        $error = "Cannot create directory for uploaded file. $error";
        return false;
    }

    if ((ozendswith($file_src,"_aes") || ozendswith($file_src,"_rsa")))  
    {
        if (!rename($file_src, $file_dest)) {
		    $error = "Error while moving encrypted file from ".$file_src." to ".$file_dest;
		    return false;
        } 
        return true;
	} 

    if (!move_uploaded_file($file_src, $file_dest)) 
    {
        $error = "Error while moving uploading file from ".$file_src." to ".$file_dest;
		return false;
	}

	return true;
}

//*****************************************************************
// File upload form
//*****************************************************************

function fileUploadHtml($index="") 
{
return ' 
<div style="width:fit-content" id="filesPreview'.$index.'">
    <div id="filesContainer'.$index.'"></div>
</div>
<div class="mt-1 mb-1">
<input class="d-none" name="filestoupload[]" id="ticketattachment'.$index.'" type="file" onchange="changeFiles'.$index.'(event);">
<label class="me-2 btn btn-light btn-sm mb-0 cursor-pointer" for="ticketattachment'.$index.'" data-bs-toggle="tooltip" data-bs-placement="top" title="" data-bs-original-title="Attach files" aria-label="Attach files">
<span style="margin-right:10px">Attach files</span>
<svg class="svg-inline--fa fa-paperclip fa-w-14 fs-1" data-fa-transform="down-2" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="paperclip" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" data-fa-i2svg="" style="transform-origin: 0.4375em 0.625em;">
        <g transform="translate(224 256)">
            <g transform="translate(0, 64)  scale(1, 1)  rotate(0 0 0)">
                <path fill="currentColor" d="M43.246 466.142c-58.43-60.289-57.341-157.511 1.386-217.581L254.392 34c44.316-45.332 116.351-45.336 160.671 0 43.89 44.894 43.943 117.329 0 162.276L232.214 383.128c-29.855 30.537-78.633 30.111-107.982-.998-28.275-29.97-27.368-77.473 1.452-106.953l143.743-146.835c6.182-6.314 16.312-6.422 22.626-.241l22.861 22.379c6.315 6.182 6.422 16.312.241 22.626L171.427 319.927c-4.932 5.045-5.236 13.428-.648 18.292 4.372 4.634 11.245 4.711 15.688.165l182.849-186.851c19.613-20.062 19.613-52.725-.011-72.798-19.189-19.627-49.957-19.637-69.154 0L90.39 293.295c-34.763 35.56-35.299 93.12-1.191 128.313 34.01 35.093 88.985 35.137 123.058.286l172.06-175.999c6.177-6.319 16.307-6.433 22.626-.256l22.877 22.364c6.319 6.177 6.434 16.307.256 22.626l-172.06 175.998c-59.576 60.938-155.943 60.216-214.77-.485z" transform="translate(-224 -256)"></path>
            </g>
        </g>
    </svg><!-- <span class="fas fa-paperclip fs-1" data-fa-transform="down-2"></span> Font Awesome fontawesome.com --></label>
</div>
<style>
@media (max-width: 767px) {
    
    #filesContainer'.$index.'{
        display:flex;
        flex-direction: column;
    }

}
@media (min-width: 767px) {
    
    #filesContainer'.$index.'{
        display:flex;
        flex-wrap: wrap;
        flex-direction: row;
    }
}
</style>

';
}

function fileUploadScript($index="") 
{
return '<script>

let fileArray'.$index.' = [];
fileArray'.$index.'=[];
let fileUploadSVG'.$index.'=`<svg class="svg-inline--fa fa-file-archive fa-w-12 fs-1" aria-hidden="true" focusable="false" data-prefix="far" data-icon="file-archive" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512" data-fa-i2svg="">
                            <path fill="currentColor" d="M128.3 160v32h32v-32zm64-96h-32v32h32zm-64 32v32h32V96zm64 32h-32v32h32zm177.6-30.1L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM256 51.9l76.1 76.1H256zM336 464H48V48h79.7v16h32V48H208v104c0 13.3 10.7 24 24 24h104zM194.2 265.7c-1.1-5.6-6-9.7-11.8-9.7h-22.1v-32h-32v32l-19.7 97.1C102 385.6 126.8 416 160 416c33.1 0 57.9-30.2 51.5-62.6zm-33.9 124.4c-17.9 0-32.4-12.1-32.4-27s14.5-27 32.4-27 32.4 12.1 32.4 27-14.5 27-32.4 27zm32-198.1h-32v32h32z"></path>
                        </svg>`;
let fileUploadSVG2'.$index.'=`<svg class="svg-inline--fa fa-times fa-w-11" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="times" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 352 512" data-fa-i2svg="">
                                <path fill="currentColor" d="M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z"></path>
                            </svg>`;

function changeFiles'.$index.'(event) {
    let file = document.getElementById("ticketattachment'.$index.'").files[0];
    fileArray'.$index.'.push(file);
    showFiles'.$index.'();
    file.value = null;
    document.getElementById("ticketattachment'.$index.'").value = null;
}
function showFiles'.$index.'() {
    let preview = document.getElementById("filesContainer'.$index.'");
    preview.innerHTML = "";
    for (let i = 0; i < fileArray'.$index.'.length; i++) {
        let currFile = fileArray'.$index.'[i];
        let fileName = currFile.name;
        let fileSize = currFile.size / 1000;
        let fileDataAsString = fileName + " (" + fileSize + "kb)";
        let div = document.createElement("div");
        div.innerHTML = `<div class="border px-2 rounded-3 d-flex flex-between-center my-1 fs--1" 
        style="background-color: #e7ebf2;">`+fileUploadSVG'.$index.'+`<span class="ms-2">` + fileDataAsString + `</span>
        <a class="text-300 p-1 ms-6" onclick="removeFile'.$index.'(\'` + fileName + `\')" href="#!" 
        data-bs-toggle="tooltip" data-bs-placement="right" title="" data-bs-original-title="Detach" aria-label="Detach">`
        +fileUploadSVG2'.$index.'+
        `</a></div>`;
        div.style.cssText = "margin-right:5px";
        preview.appendChild(div);
        console.log(fileArray'.$index.');
    }
}
function removeFile'.$index.'(fileName) {
    fileArray'.$index.' = fileArray'.$index.'.filter((el) => (el.name !== fileName));
    showFiles'.$index.'();
}
let myform'.$index.' = document.getElementById("filesContainer'.$index.'").closest("form");
myform'.$index.'.onsubmit = async (e) => {
    e.preventDefault();
    let formData=new FormData(myform'.$index.');
    formData.delete("filestoupload[]");
    for (let i = 0; i < fileArray'.$index.'.length; i++) {
        formData.append("filestoupload[]",fileArray'.$index.'[i])
    }
    let response=await fetch("index.php",{
        method: "POST",
        body: formData
    });
    fileArray'.$index.'=[];
    let text = await response.text();
    document.open();
    document.write(text);
    document.close();
    //myform.submit();
};
</script>
';
}

//*****************************************************************
// File download
// $encryptionmethod = 'none'|'aes'|'rsa'
//*****************************************************************

function displayDownloadLink($nicename, $size, $storedpath,$accessthrough=null)
{
    global $page_upload_filedownload;
    //echo "Ps: $page_upload_filedownload";exit;
    $through = (!isempty($accessthrough)) ? "&accessthrough=$accessthrough" : "";
    $svg = '<svg class="svg-inline--fa fa-file-archive fa-w-12 fs-1" aria-hidden="true" focusable="false" data-prefix="far" data-icon="file-archive" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512" data-fa-i2svg=""><path fill="currentColor" d="M128.3 160v32h32v-32zm64-96h-32v32h32zm-64 32v32h32V96zm64 32h-32v32h32zm177.6-30.1L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM256 51.9l76.1 76.1H256zM336 464H48V48h79.7v16h32V48H208v104c0 13.3 10.7 24 24 24h104zM194.2 265.7c-1.1-5.6-6-9.7-11.8-9.7h-22.1v-32h-32v32l-19.7 97.1C102 385.6 126.8 416 160 416c33.1 0 57.9-30.2 51.5-62.6zm-33.9 124.4c-17.9 0-32.4-12.1-32.4-27s14.5-27 32.4-27 32.4 12.1 32.4 27-14.5 27-32.4 27zm32-198.1h-32v32h32z"></path></svg>';
    $ret = '<div class="border p-2 rounded-3 d-flex my-1 fs--1" style="background-color: #e7ebf2;"><span>'.$svg.'</span><span class="ms-2">';
    $ret .= "<a href='index.php?srv=system&owpn=page_system_filedownload&nicename=".urlencode($nicename)."&path=".urlencode($storedpath)."&nocache=".ozrndstr()."'>$nicename (".humanFileSize($size).")</a>";
    $ret .= '</span></div>';
    return $ret;
}

?>
