<?php
include_once("$sysdir/authentication/registrationsecondary.php");

process_phone_add_request($phone_adderror);

function process_phone_add_request(&$error){
    global $phone_addrequest;
    if(!loadRequiredReqParams($_,"phone_addrequest")) return true;
    return process_phone_add($error);
}

function process_phone_add(&$error){
    global $myuserid;
    if(!get_phone_add_params($phone,$error)) return false;
    return create_phone_secondary_user($phone,$error);
}

function get_phone_add_params(&$phone,&$error){
    global $phone_myphone;
    if(!loadRequiredReqParams($error,"phone_myphone")) return false;
    $phone = preg_replace('/\s+/', '', $phone_myphone);;
    if(!isPhoneNumberInternational($phone_myphone)) {
        $error = "Invalid phone number: " . htmlspecialchars($phone_myphone);
        return false;
    }
    return true;
}

function create_phone_secondary_user($phone, &$error){
    $uid = md5($phone);
    if(userExists($uid))
    {
        $error="This Phone number is already tied to a different account, so it can't be linked here.";
        return false;
    }
    if(!addSecondaryUser($phone,"phone","",$_,$error)) return false;
    $url = "index.php?owpn=page_profile_loginmethods".nocache();
    header("Location: $url");
    return true;
}

function addPhoneForm(){
    global $phone_adderror, $owpn;

    $returnurl = "index.php?owpn=page_profile_loginmethods".nocache();

    $errorHtml = ($phone_adderror !== null)
        ? '<span style="color:red;">' . htmlspecialchars($phone_adderror) . '</span>'
        : '';

    $phoneform = <<<HTML
    <div>
      <style>
        .phone-group {
          display: inline-flex;
          align-items: center;
          gap: 8px;
          width: 100%;
          box-sizing: border-box;
        }
        .phone-group select {
          max-width: 256px;
          padding: 0 36px 0 12px;
          white-space: nowrap;
          overflow: hidden;
          text-overflow: ellipsis;
          -webkit-appearance: none;
          appearance: none;
          background-image:
            url("data:image/svg+xml;charset=US-8bit,%3Csvg width='10' height='6' viewBox='0 0 10 6' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M0 0l5 6 5-6z' fill='%23666'/%3E%3C/svg%3E");
          background-repeat: no-repeat;
          background-position: right 12px center;
          background-size: 10px 6px;
          height: 2.5rem;
        }
        .phone-group input {
          max-width: 350px;
          height: 2.5rem;
        }
        .phone-group select:focus,
        .phone-group input:focus {
          outline: none;
          border-color: #4285f4;
          box-shadow: 0 1px 2px rgba(66,133,244,0.3);
        }
        #phone_error {
          display: block;
          margin-top: 4px;
          color: red;
          font-size: 0.875rem;
        }
      </style>

      <form id="addPhoneForm" action="index.php" method="post">
        <input type="hidden" name="owpn" value="{$owpn}">
        <input type="hidden" name="phone_addrequest" value="addphone">
        <input type="hidden" name="phone_myphone" id="phone_myphone" value="">

        <div class="mb-3">
          <label class="form-label" for="phone_country">Country / Code</label>
          <div class="phone-group">
            <select id="phone_country" name="phone_country" class="form-control"></select>
            <input
              class="form-control"
              type="text"
              id="phone_visiblephone"
              name="phone_visiblephone"
              placeholder="Phone number"
              required
            />
          </div>
          <span id="phone_error">{$errorHtml}</span>
        </div>

        <div class="mb-3">
            <button class="btn btn-danger" type="button" onclick="window.location.href='{$returnurl}'">
                Cancel
            </button>
            <button class="btn btn-primary" type="submit">
                Add Phone
            </button>
        </div>
      </form>
    </div>

    <script src="/ozekiservices/system/attachments/1/phonenumber/libphonenumber-max.js"></script>
    <script src="/ozekiservices/system/attachments/1/phonenumber/countries-and-timezones.js"></script>
    <script src="/ozekiservices/system/attachments/1/phonenumber/getcountries.js"></script>
    <script>
        (function(){
            const select = document.getElementById('phone_country');
            const countries = getAllCountries();
            countries
            .sort((a,b)=>a.name.localeCompare(b.name))
            .forEach(c=>{
                const opt = document.createElement('option');
                opt.value = c.code;
                opt.textContent = `\${c.name} (+\${c.dialCode})`;
                select.appendChild(opt);
            });
            const tz = Intl.DateTimeFormat().resolvedOptions().timeZone;
            const defaultC = ct.getTimezone(tz).countries[0] || 'HU';
            select.value = defaultC;
        })();

       document.getElementById('addPhoneForm').addEventListener('submit', function(e) {
    e.preventDefault();
    const error = document.getElementById('phone_error');
    error.textContent = '';

    const country = document.getElementById('phone_country').value;
    const number  = document.getElementById('phone_visiblephone').value;

    try {
        const pn = libphonenumber.parsePhoneNumber(number, country);

        if(!pn.isValid() || !pn.isPossible()) {
            throw new Error();
        }
        document.getElementById('phone_myphone').value = pn.formatInternational().replace(/ /g,'');
        e.target.submit();
    } catch(err) {
        console.log(err);
        error.textContent = 'Invalid phone number. Please check the format.';
    }
  });

    </script>
HTML;

    echo card("Add phone secondary login method");
    echo $phoneform;
    echo cardend();
    $phone_adderror = null;
}


addPhoneForm();
?>