<?php
include_once("$sysdir/authentication/registrationsecondary.php");
include_once("$sysdir/authentication/accountdelete.php");

process_email_add_request($email_addemailerror);

function process_email_add_request(&$error){
    global $email_addemailrequest;
    if(!loadRequiredReqParams($_,"email_addemailrequest")) return true;
    return process_email_add($error);
}

function process_email_add(&$error){
    if(!get_email_add_params($email,$password,$ispasswordrequired,$error)) return false;
    return create_email_secondary_user($email,$password,$ispasswordrequired,$error);
}

function get_email_add_params(&$email,&$password,&$ispasswordrequired,&$error){
    global $email_myemail;
    if(!loadRequiredReqParams($error,"email_myemail")) return false;
    if(!isemail2($email_myemail)) {
        $error = "Invalid email address: " . htmlspecialchars($email_myemail);
        return false;
    }
    $email = strtolower(trim($email_myemail));
    return true;
}

function create_email_secondary_user($email,$password,$ispasswordrequired, &$error){
    $uid = md5($email);

    if(userExists($uid)) {
        $error = "This Email is already tied to a different account, so it can't be linked here. To use it as a secondary account, log in with the existing account and delete it first.";
        return false;
    }

    if(!addSecondaryUser($email,"email","",$_,$error)) return false;
    $url = "index.php?owpn=page_profile_loginmethods".nocache();
    header("Location: $url");
    return true;
}

function addEmailForm(){
    global $email_addemailerror, $email_myemail, $owpn;

    $returnurl = "index.php?owpn=page_profile_loginmethods".nocache();


    $email_addemailerrorHtml = ($email_addemailerror !== null) ? '<span style="color:red">' . htmlspecialchars($email_addemailerror) . '</span>' : '';
   
    $emailForm = <<<EMAILFORM
    <div style="max-width:400px">
        <form enctype="multipart/form-data" action="index.php" method="post">
            <input type="hidden" name="owpn" value="{$owpn}">
            <input type="hidden" name="email_addemailrequest" value="addemail">
            <div class="mb-3">
                <label class="form-label" for="email_myemail">Email</label>
                <input
                    class="form-control"
                    name="email_myemail"
                    id="email_myemail"
                    type="email"
                    placeholder="you@example.com"
                    value="{$email_myemail}"
                    required
                />
                {$email_addemailerrorHtml}
            </div>
            <div class="mb-3">
                <button class="btn btn-danger" type="button" onclick="window.location.href='{$returnurl}'">
                Cancel
                </button>
                <button class="btn btn-primary" type="submit" onclick="addEmailSubmitHandler()">
                    Add Email
                </button>
            </div>
        </form>
    </div>
EMAILFORM;
    echo card("Add email secondary login method");
    echo $emailForm;
    echo cardend();
    $email_addemailerror = null;
}

addEmailForm();
?>