<?php
include_once("$sysdir/authentication/accountdelete.php");
include_once("$dirprefix/ozekiservices/system/common/loginmethods_common.php");

$phone_icon_path = "/ozekiservices/system/attachments/1/phone.svg";

function displayloginmethods_available_phone(){
    global $myuserid,$phone_icon_path;
    $methods = [];
    $button = display_phone_add_button();
    $methods[] = printLoginMethodLine("Phone number","Add phone number",$button,$phone_icon_path);

    return $methods;
}

function displayloginmethods_current_phone(){
    global $myuserid,$phone_icon_path;
    $methods = [];

    $phoneUsers = get_secondary_users_by_type("phone");
    if (empty($phoneUsers)) {
        return $methods;
    }

    foreach ($phoneUsers as $user) {
        $emailOrPhoneOrOther = $user['emailorphoneorother'] ?? 'Phone account';
        $button = display_phone_remove_button($user['secondaryuserid']);
        $methods[] = printLoginMethodLine('Phone', $emailOrPhoneOrOther, $button,$phone_icon_path);
    }

    return $methods;
}

global $loginmethods_current,$loginmethods_available;
$loginmethods_current["phone"]   = 'displayloginmethods_current_phone';
$loginmethods_available["phone"] = 'displayloginmethods_available_phone';

function display_phone_add_button() {
    global $phone_adderror;
    $url = "index.php?owpn=page_system_addloginmethod_phonenumber".nocache();

    $ret = <<<HTML

    <div class="d-flex justify-content-center flex-column align-items-center">
        <button class="btn btn-primary btn-sm ms-2" type="button" onclick="window.location.href='{$url}'">
            Add
        </button>
    HTML;

    if (!empty($phone_adderror)) {
        $ret .= <<<ERR
        <div class="alert alert-danger mt-2" role="alert" style="width: 100%; max-width: 300px; text-align: center;">
            {$phone_adderror}
        </div>
        ERR;
    }
    return $ret;
}

function display_phone_remove_button($uid){
    global $owpn;

    return <<<REMOVEBUTTON
    <form method="post" class="d-inline">
        <input type="hidden" name="phone_removerequest" value="remove">
        <input type="hidden" name="owpn"  value="{$owpn}">
        <input type="hidden" name="phone_secondary_uid"  value="{$uid}">
        <button type="submit"
                class="btn btn-danger btn-sm ms-2">
            Remove
        </button>
    </form>
REMOVEBUTTON;
}

function processphoneaccountdelete(&$error){
    global $phone_removerequest;
    loadOptionalRequestParameters("phone_removerequest");
    if($phone_removerequest!=="remove")
    {
        return true;
    }
    global $phone_secondary_uid;
    if(!loadRequiredReqParams($error,"phone_secondary_uid"))
    {
        $error="Missing request parameter: phone_secondary_uid";
        return false;
    }
    return deleteSecondaryUser($phone_secondary_uid,$error);
}

processphoneaccountdelete($phonedeleteerror);

?>