<?php
include_once("$sysdir/authentication/accountdelete.php");
include_once("$dirprefix/ozekiservices/system/common/loginmethods_common.php");


$email_icon_path = "/ozekiservices/system/attachments/1/email.svg";

function displayloginmethods_available_email(){
    global $myuserid,$email_icon_path;
    $methods = [];
    $button = display_email_add_button();
    $methods[] = printLoginMethodLine("Email","Add email account",$button,$email_icon_path);

    return $methods;
}

function displayloginmethods_current_email(){
    global $myuserid, $email_icon_path;
    $methods = [];

    $emailUsers = get_secondary_users_by_type("email");
    if (empty($emailUsers)) {
        return $methods;
    }

    foreach ($emailUsers as $user) {
        $emailOrPhoneOrOther = $user['emailorphoneorother'] ?? 'Email account';
        $button = display_email_remove_button($user['secondaryuserid']);
        $methods[] = printLoginMethodLine('Email', $emailOrPhoneOrOther, $button, $email_icon_path);
    }

    return $methods;
}


global $loginmethods_current,$loginmethods_available;
$loginmethods_current["email"]   = 'displayloginmethods_current_email';
$loginmethods_available["email"] = 'displayloginmethods_available_email';


function display_email_add_button() {
    global $email_addemailerror;

    $url = "index.php?owpn=page_system_addloginmethod_email".nocache();

    $ret = <<<HTML

    <div class="d-flex justify-content-center flex-column align-items-center">
        <button class="btn btn-primary btn-sm ms-2" type="button" onclick="window.location.href='{$url}'">
            Add
        </button>
    HTML;

    if (!empty($email_addemailerror)) {
        $ret .= <<<ERR
        <div class="alert alert-danger mt-2" role="alert" style="width: 100%; max-width: 300px; text-align: center;">
            {$email_addemailerror}
        </div>
        ERR;
    }
    return $ret;
}

function display_email_remove_button($uid){
    global $owpn;

    return <<<REMOVEBUTTON
    <form method="post" class="d-inline">
        <input type="hidden" name="email_removeemailrequest" value="remove">
        <input type="hidden" name="owpn"  value="{$owpn}">
        <input type="hidden" name="email_secondary_uid"  value="{$uid}">
        <button type="submit"
                class="btn btn-danger btn-sm ms-2">
            Remove
        </button>
    </form>
REMOVEBUTTON;
}

function processemailaccountdelete(&$error){
    global $email_removeemailrequest;
    loadOptionalRequestParameters("email_removeemailrequest");
    if($email_removeemailrequest!=="remove")
    {
        return true;
    }
    global $email_secondary_uid;
    if(!loadRequiredReqParams($error,"email_secondary_uid"))
    {
        $error="Missing request parameter: email_secondary_uid";
        return false;
    }
    return deleteSecondaryUser($email_secondary_uid,$error);
}

processemailaccountdelete($emaildeleteerror);

?>