<?php
function printLoginMethodLine($service_name,$description,$buttonHtml,$iconPath) {
    $icon_path = $iconPath;
    $icon_html = '';
    $icon_html = <<<SVG
    <svg width="60" height="60" style="padding: 0;">       
        <image href="$icon_path" x="50%" y="50%" transform="translate(-15,-15)" width="30" height="30"/>    
    </svg>
    SVG;

    return <<<HTML
    <div class="row border-bottom m-0">
      <div class="d-flex align-items-center col-8 px-0">
        <table>
          <tr>
            <td>
                $icon_html
            </td>
            <td>
              <div class="text-start">
                <h5 class="mb-0 text-capitalize">$service_name</h5>
                <span style="font-size:0.8rem text-capitalize">$description</span>
              </div>
            </td>
          </tr>
        </table>
      </div>
      <div class="d-flex align-items-center justify-content-end col-4 px-0">
        <table>
          <tr>
            <td>
              $buttonHtml
            </td>
          </tr>
        </table>
      </div>
    </div>
HTML;
}

function get_secondary_users_by_type($type,$all = true) {
    $secondaryusers = getMySecondaryUsers();
    $users = [];
    foreach ($secondaryusers as $id => $user) {
        if($user["type"] == $type) {
            if(!$all) return $user;
            $users[$id] = $user;
        }
    }
    return $users;
}


?>