<?php
//example
// include_once("$servicesdir/system/common/common.export.php");
// echo exportTable("tableDivID","data.xlsx");
//


global $includedExportXlsJS;
$includedExportXlsJS = false;

function includeExportXlsJS()
{

    $ret = <<<EXPORTJS
<script src="/ozekiservices/system/attachments/1/export/xlsx.full.min.js"></script>

<script>
function exportTableToXLSX(tableElement, fileName = 'export.xlsx') {
    // Extract data from table
    const rows = tableElement.querySelectorAll('tr');
    const data = [];
    
    // Iterate through rows
    for (const row of rows) {
        const rowData = [];
        const cells = row.querySelectorAll('td, th');
        
        // Iterate through cells
        for (const cell of cells) {
            rowData.push(cell.textContent);
        }
        data.push(rowData);
    }

    // Create worksheet
    const worksheet = XLSX.utils.aoa_to_sheet(data);
    
    // Create workbook
    const workbook = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(workbook, worksheet, 'Sheet1');
    
    // Save to file
    XLSX.writeFile(workbook, fileName);
}
</script>
EXPORTJS;

    return $ret;
}

function exportTable($tableDivID,$fileName="data.xlsx")
{
    $ret = "";
    global $includedExportXlsJS;
    if (!$includedExportXlsJS)
    {
        $ret .=  includeExportXlsJS();
        $includedExportXlsJS = true;
    } 

$ret .= <<<EXPORTBUTTON
<button onclick="exportTableToXLSX(document.getElementById('$tableDivID'), '$fileName')">
    Export to XLSX
</button>
EXPORTBUTTON;

    return $ret;
}


?>