function ozhideshow($hideid,$showid) {
  var h = document.getElementById($hideid);
  h.style.display = "none";

  var s = document.getElementById($showid);
  s.style.display = "block";
}

function ozhide($hideid) {
  var h = document.getElementById($hideid);
  h.style.display = "none";
}

function ozshow($showid) {
   var s = document.getElementById($showid);
   s.style.display = "block";
}

function ozshowhide($id)
{
  var o = document.getElementById($id);
  if (o.style.display === "none")
  {
    o.style.display = "block";
  } else {
    o.style.display = "none";
  }
}

function removeDOMElementById(id) {
  let element = document.getElementById(id);
  element.parentElement.removeChild(element);
}

function GroupBoxHideContent(event) {
  var title = event.target;
  var titleParent = title.parentNode;
  var content = titleParent.nextElementSibling;
  var contentParent = content.parentNode;
  if (content != null && title != null) {
      if (!$(contentParent).hasClass("GroupBoxHide") && content.style.display == "block" || content.style.display == "") {
        if (!$(contentParent).hasClass("tempClass")) {
            $(contentParent).addClass("tempClass");
            $(contentParent).removeClass("GroupBoxShow");
            $(contentParent).addClass("GroupBoxHide");
            $(titleParent).append($("<img onclick=\"GroupBoxHideContent(event); \" id=\"" + titleParent.firstChild.id + "_img\" src=\"/ozekiservices/system/attachments/1/img/grpboxopen.svg\" class=\"GroupBoxIcon\" />"));
            $(contentParent).removeClass("tempClass");
            content.style.display = "none";
        }
      }
      else 
      {
        if (!$(contentParent).hasClass("tempClass") && content.style.display == "none") {
          $(contentParent).addClass("tempClass");
          $(contentParent).removeClass("GroupBoxHide");
          $(contentParent).addClass("GroupBoxShow");
          content.style.display = "block";
          var img = document.getElementById(titleParent.firstChild.id + "_img");
          if (img != null) {
              titleParent.removeChild(img);
              $(contentParent).removeClass("tempClass");
          }
        }
      }
  }
}

function HideContent(id) {
  var title = document.getElementById(id);
  var titleParent = title.parentNode;
  var content = titleParent.nextElementSibling;
  var contentParent = content.parentNode;

  if (!$(contentParent).hasClass("GroupBoxHide") && content.style.display == "block" || content.style.display == "") {
      $(content).slideFadeToggle(0, "swing", function () {
          $(contentParent).removeClass("GroupBoxShow");
          $(contentParent).addClass("GroupBoxHide");
          $(titleParent).append($("<img onclick=\"GroupBoxHideContent(event); \" id=\"" + titleParent.firstChild.id + "_img\" src=\"/Image/GroupBoxImage.svg\" class=\"GroupBoxIcon\" />"));
      });
  }
}

function ShowContent(id) {
  var title = document.getElementById(id);
  var titleParent = title.parentNode;
  var content = titleParent.nextElementSibling;
  var contentParent = content.parentNode;

  if (!$(contentParent).hasClass("GroupBoxShow") && content.style.display == "none") {
      $(content).slideFadeToggle(500, "swing", function () {

          $(contentParent).removeClass("GroupBoxHide");
          $(contentParent).addClass("GroupBoxShow");

          var img = document.getElementById(titleParent.firstChild.id + "_img");
          if (img != null) {
              titleParent.removeChild(img);
          }
      });
  }
}

//********************************************
// CefSharp / bind ozWebView to window
//********************************************

//FIXME: CefSharp.BindObjectAsync képes berahadni, ha többször kerül meghívásra
async function bindOzWebViewIfPossible() {
  if (!window.CefSharp) return true;

  const promiseFieldName = 'ozWebViewSetupPromise';
  if (!window[promiseFieldName] && window.ozWebView) {
    console.info('ozWebView already bound to window...');
    return true;
  }

  try {
    if (!window[promiseFieldName]) {
      const promise = bindOzWebViewUnsafe();
      window[promiseFieldName] = promise;
    }
    console.info('Binding ozWebView to window...');
    await window[promiseFieldName];
    console.info('ozWebView bound to window.');
    return true;
  } catch (error) {
    console.error('Failed to bind ozWebView to window.', error);
    return false;
  } finally {
    window[promiseFieldName] && delete window[promiseFieldName];
  }
}

async function bindOzWebViewUnsafe() {
  await cefSharpBindObjectAsyncSafe('ozWebView');
  if (!window.ozWebView) throw new Error('window.ozWebView is null or undefined.');
  installOzWebViewEventExtension();
  if (!window.ozWebView.getClientInfo) return;
  try {
    const clientInfo = await window.ozWebView.getClientInfo();
    window.ozWebView.appPlatform = clientInfo.platform;
    window.ozWebView.appVersion = clientInfo.version;
  } catch (error) {
    console.log('Failed to load client info.', error.message);
  }
}

function installOzWebViewEventExtension() {
  if (!window.ozWebView) {
    console.error('Failed to install ozWebView event extension. window.ozWebView is null or undefined.');
    return;
  }
  if (typeof (window.ozWebView.addEventListener) === 'function') {
    console.warn('ozWebView event extension is already installed.');
    return;
  }
  Object.assign(window.ozWebView, {
    _eventCallbacks: {},
    dispatchEvent(eventName, ...eventArgs) {
      eventName = eventName.toLowerCase();
      if (!(eventName in this._eventCallbacks)) {
        console.warn(`No callback registered for event '${eventName}'.`);
        return;
      }
      this._eventCallbacks[eventName].forEach(callback => {
        try {
          callback.call(self, ...eventArgs);
        } catch (err) {
          console.error(`Failed to execute callback function in ozWebView. ${err.message}`);
        }
      });
    },
    addEventListener(eventName, callback) {
      eventName = eventName.toLowerCase();
      if (!(eventName in this._eventCallbacks)) {
        this._eventCallbacks[eventName] = [];
      }
      this._eventCallbacks[eventName].push(callback);
    },
    removeEventListener(eventName, callback) {
      eventName = eventName.toLowerCase();
      if (!(eventName in this._eventCallbacks)) return;
      this._eventCallbacks[eventName] = this._eventCallbacks[eventName].filter(cb => cb !== callback);
    },
  });
}

async function cefSharpBindObjectAsyncSafe(objectName) {
  console.info(`Binding object '${objectName}' to window...`);
  const promiseFieldName = objectName + 'BindObjectPromise';
  try {
    if (!window[promiseFieldName]) {
      const promise = Promise.race([
        CefSharp.BindObjectAsync(objectName, { IgnoreCache: true, NotifyIfAlreadyBound: true }),
        new Promise((_, reject) => setTimeout(() => reject(new Error('CefSharp.BindObjectAsync timed out after 3 seconds.')), 3000))
      ]);
      window[promiseFieldName] = promise;
    }
    await window[promiseFieldName];
    console.log(`Object '${objectName}' bound to window.`);
  } catch (error) {
    console.error(`Failed to bind object '${objectName}' to window.`, error);
  } finally {
    window[promiseFieldName] && delete window[promiseFieldName];
  }
}