<?php
function handlerequest_users_list($userid, $req, &$resp, &$error) {
    // Parameter: userids (comma-separated list of MD5 user IDs)
    $userids = $req["userids"];

    $error="";
    if (empty($userids)) {
        $error = 'Parameter "userids" is required.';
        ozerror(__FILE__, $error, $resp, $error);
        return;
    }

    $ids   = array_map('trim', explode(',', $userids));
    $users = [];

    foreach ($ids as $uid) {
        if (ismd5($uid)) {
            $users[$uid] = getName($uid);
        }
    }

    $resp["status"] = "OK";
    $resp["errormessage"] = $error;
    $resp["users"]   = $users;
}
?>
