<?php
function handlerequest_users_create($userid, $req, &$resp, &$error) {
    global $dirprefix;

    // Required: email, fullname, password
    // Optional: mobile, country, nick
    loadReqParams('email', 'fullname', 'password', 'mobile', 'country', 'nick');

    if (empty($email) || empty($fullname) || empty($password)) {
        $error = 'Missing required fields (email, fullname, password).';
        ozerror(__FILE__, $error, $resp, $error);
        return;
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Invalid email address.';
        ozerror(__FILE__, $error, $resp, $error);
        return;
    }

    $userid = md5(strtolower($email));
    $privateKey = null;

    include_once("$dirprefix/ozeki/sys/authentication/registrationcreateuser.php");

    if (!createUser($userid, $email, $fullname, $password, $privateKey, $error,
                    $mobile ?? '', $country ?? null, $nick ?? null)) {
        ozerror(__FILE__, $error, $resp, $error);
        return;
    }

    $resp["success"] = true;
    $resp["userid"]   = $userid;
    $resp["status"] = "OK";
    $resp["errormessage"] = $error;
}
?>
