<?php
function handlerequest_users_authenticate($userid, $req, &$resp, &$error) {
    global $dirprefix;

    // Accept either email or userid plus password
    loadReqParams('email', 'userid', 'password');

    if (empty($password)) {
        $error = 'Password is required.';
        ozerror(__FILE__, $error, $resp, $error);
        return;
    }

    if (!empty($email)) {
        $userid = md5(strtolower($email));
    }

    if (!ismd5($userid)) {
        $error = 'Invalid userid.';
        ozerror(__FILE__, $error, $resp, $error);
        return;
    }

    $privateKey = $publicKey = $aesprivate = $aesshared = $userdetails = null;

    include_once("$dirprefix/ozeki/sys/authentication/login.inc.php");

    if (!loginUser($userid, $password, $privateKey, $publicKey,
                   $aesprivate, $aesshared, $userdetails, $error)) {
        ozerror(__FILE__, $error, $resp, $error);
        return;
    }

    $resp["success"]  = true;
    $resp["userid"]   = $userid;
    $resp["fullname"] = $userdetails['fullname'] ?? '';
    $resp["status"] = "OK";
    $resp["errormessage"] = $error;
}
?>
