# Users API

The **users** API provides basic user management functions for Ozeki services.  
It is registered in `ozekiservices/system/_api.php` as:

```php
addapi("users","api/users/users.php",$systemapi_session_enabled);
```

All requests must be signed using the standard Ozeki signed‑input mechanism
(`isValidSignedInput`). Responses are JSON‑encoded and returned with
`Content-Type: application/json`.

## Endpoint

```
http://<host>/ozeki/index.php?api=users&action=<action>
```

| Action | HTTP Method | Required Parameters | Optional Parameters | Description |
|--------|-------------|---------------------|---------------------|-------------|
| `create` | POST | `email`, `fullname`, `password` | `mobile`, `country`, `nick` | Creates a new user. Returns `userid` (MD5 of the lower‑cased email) on success. |
| `authenticate` | POST | `password` and either `email` **or** `userid` | – | Authenticates a user. Returns `userid` and `fullname` on success. |
| `list` | GET | `userids` (comma‑separated list of MD5 user IDs) | – | Returns a map of each requested `userid` to its display name (`fullname`). Invalid IDs are ignored. |

## Example Requests

### Create a User

```bash
curl -X POST "http://localhost/ozeki/index.php?api=users&action=create" \
     -d "email=jane.doe@example.com" \
     -d "fullname=Jane Doe" \
     -d "password=Secret123" \
     -d "mobile=+1234567890"
```

**Response**

```json
{
  "success": true,
  "userid": "e1cbb0c3879af8347246f12c559a86b5"
}
```

### Authenticate a User

```bash
curl -X POST "http://localhost/ozeki/index.php?api=users&action=authenticate" \
     -d "email=jane.doe@example.com" \
     -d "password=Secret123"
```

**Response**

```json
{
  "success": true,
  "userid": "e1cbb0c3879af8347246f12c559a86b5",
  "fullname": "Jane Doe"
}
```

### List User Names

```bash
curl -G "http://localhost/ozeki/index.php?api=users&action=list" \
     --data-urlencode "userids=e1cbb0c3879af8347246f12c559a86b5,invaliduserid"
```

**Response**

```json
{
  "success": true,
  "users": {
    "e1cbb0c3879af8347246f12c559a86b5": "Jane Doe"
  }
}
```

## Error Handling

If a required parameter is missing or validation fails, the API returns:

```json
{
  "error": "Descriptive error message"
}
```

The HTTP status code is always `200 OK`; errors are communicated via the JSON payload.

## Security Notes

* All passwords are hashed with `sha512` and stored encrypted using RSA/AES as in the existing Ozeki authentication flow.  
* Input validation is performed (`filter_var` for email, `ismd5` for user IDs).  
* The API respects the same signed‑request validation used by other system APIs, preventing unauthorized access.  

---

**Test Script**

A simple Bash script (`test_users.sh`) is provided in the repository root to exercise the three actions.

```bash
#!/bin/bash
# ... (see test_users.sh)
```

Run it with:

```bash
chmod +x test_users.sh
./test_users.sh
```
