<?php
include_once "$sysdir/base/sessions.php";
include_once "$sysdir/authentication/login.inc.php";
include_once "$sysdir/authentication/loginsession.php";

if(!isUserLoggedIn($error))
{
    http_response_code(401);
    exit;
}

//*****************************************************************
// Load and validate the 'path' req param
//*****************************************************************

loadReqParams("path");
if(!$path)
{
    http_response_code(400);
    exit;
}

if(!str_starts_with($path,"/"))$path="/".$path;
$fullpath=realpath($datadir.$path);
if($fullpath===false)
{
    http_response_code(404);
    exit;
}

//*****************************************************************
// Ensure user can only access their own dir
//*****************************************************************

$myprefix="/registrations/".$myuserid;
$mydatadir=realpath($datadir.$myprefix);
if(!str_starts_with($fullpath,$mydatadir))
{
    http_response_code(403);
    exit;
}

if(!is_file($fullpath))
{
    http_response_code(404);
    exit;
}

//*****************************************************************
// HTTP caching: handle 'If-Modified-Since' to support conditional GET requests
//*****************************************************************
$lastmodified=gmdate("D, d M Y H:i:s",filemtime($fullpath))." GMT";
$ifmodifiedsince=$_SERVER["HTTP_IF_MODIFIED_SINCE"]??false;
if($ifmodifiedsince&&$ifmodifiedsince==$lastmodified)
{
    http_response_code(304);
    header("Cache-Control: no-cache, private");
    exit;
}

//*****************************************************************
// Set headers and send the file to the client
//*****************************************************************

$filename=basename($fullpath);
$mimetype=mime_content_type($fullpath);
if(!$mimetype)$mimetype="application/octet-stream";
http_response_code(200);
header("Cache-Control: no-cache, private");
header("Content-Type: ".$mimetype);
header("Content-Disposition: inline; filename=\"".$filename."\"");
header("Content-Length: ".filesize($fullpath));
header("Last-Modified: ".$lastmodified);

ob_clean();
flush();
readfile($fullpath);
exit;
?>