<?php
include_once("$sysdir/base/layout.php");

if (!isset($_REQUEST["c"])) 
{
    echo "Invalid input";
    exit;
}

if (!isset($siteid) || strlen($siteid)<6)
{
    echo "Invalid site configuration";
    exit;
}

$enc = $_REQUEST["c"];
$enc = str_replace(" ","+",$enc);
$key = convertToAesKey($siteid);
$dec = decryptTextAES($key, $enc);

if (!$dec)
{
    echo "Invalid encrypted request";
    exit;
}

$json = json_decode($dec,true);

$userid = $json["u"];
$validuntil = $json["v"];
$pass = $json["p"]; 
$sha = sha512($json["p"]);
$name = GetName($userid);
$error = "";
$content = "";

$pwfile = "$regdir/$userid/privatekey_".$sha.".txt";

if (!file_exists($pwfile))
{
    echo "This password reset link is invalid.";
    exit;
}

if (isset($_REQUEST["myaction"]) && $_REQUEST["myaction"]=='changepassword')
{
    $pw1 = $_REQUEST["myuserpassword1"];
    $pw2 = $_REQUEST["myuserpassword2"];

    if ($pw1 != $pw2)
    {
        $error = "The two passwords do not match";
    }

    if ($error=="" && !isPasswordTooShort($pw1,$errorp))
    {
        $error = $errorp;
    }

    if ($error == "")
    {
        include_once("$sysdir/authentication/passwordreset.php");
        passwordResetByUser($userid,$pass,$pw1,"overwrite",$error);
    }

    if ($error == "")
    {
        $content = displaySuccess("Password reset","Your password was successfully reset", "Go to login", "page_authentication_login");
    }
}


$form = <<<RESETFORM
<div class="card col-md-3 p-0" >
	<div class="card-header">
        <img src="/ozekiservices/system/attachments/1/img/white_ozeki_logo_web_transparent.png" width="200px" class="mb-3"/> 
		<h4>Create new password for <br><b>$name</b></h4>
	</div>
	<div class="card-body bg-light">
		<form enctype="multipart/form-data" action="index.php" method="post" novalidate>
			<input type="hidden" name="api" value="resetpassword">
            <input type="hidden" name="srv" value="system">
			<input type="hidden" name="myaction" value="changepassword">
            <input type="hidden" name="c" value="$enc">
			
			<div class="mb-3">
				<label class="form-label" for="subject">New password</label>
				<input class="form-control" name="myuserpassword1" type="text"  readonly onfocus="this.removeAttribute('readonly');" required/>
			</div>
			<div class="mb-3">
				<label class="form-label" for="subject">Repeat password</label>
				<input class="form-control" name="myuserpassword2" type="text"  readonly onfocus="this.removeAttribute('readonly');" required/>
			</div>
			<div class="mb-3">
				<button class="btn btn-primary" type="submit" name="messagecreate-submit">Save</button>
			</div>
            <div class="mb-3">
                <label style='color:red'>$error</label>
            </div>
		</form>
	</div>
</div>

RESETFORM;

echo printHtmlHeader();
echo printMainContainerStart();
echo printMainContentStart();
echo "<center>";
echo "<div style='margin-top:20px'>";
if ($content != "") echo $content; else echo $form;
echo "</div>";
echo "</center>";
echo printMainContentEnd();
echo printMainContainerEnd();
echo printHtmlFooter();

?>