<?php
//*****************************************************************
// Image download server
// 
// Example use:
// -----------------------------------
// http://localhost/ozeki/index.php?srv=system&api=imagedownload&path=%2Fregistrations%2Fd0eafbf473d60808db0a36d53b251b10%2Fprofile%2Fimage%2Fprofile.webp_aes&k=6nNJHwBfBCFFPbtxRWwbDUJMkOe3UnLXxdMMu1TVn%2F9cAhCElQjEwvatdu8PB2gY
// 
//
// I. How to download an encrypted image
// -----------------------------------
// <img src='index.php?owpn=$page_upload_imagedownload&path=$storedpath'>
// <img src='http://localhost/ozeki/index.php?srv=system&api=imagedownload&
// path=%2Fregistrations%2Fd0eafbf473d60808db0a36d53b251b10%2Fprofile%2Fimage%2Fprofile.webp_aes'>
//
// Example 1: nincs serviceid
// img src: /registrations/d0eafbf473d60808db0a36d53b251b10/profile/image/profile.webp_aes
// ownerid: d0eafbf473d60808db0a36d53b251b10
// servicename: profile
// encrypted image: image/profile.webp_aes
//
// Example 2: van serviceid
// img src: /registrations/d0eafbf473d60808db0a36d53b251b10/ticket/454404f8a0258f9bfa82d6d300a8d974/myimage.webp_aes
// ownerid: d0eafbf473d60808db0a36d53b251b10
// servicename: ticket
// serviceid: 454404f8a0258f9bfa82d6d300a8d974
// encrypted image: myimage.webp_aes
//
// II. How to save an encrypted image
// -----------------------------------
// if (!loadOrGenerateMyAesKeyForSrv($servicename,$serviceid,$aesdecrypted,$error)) return false;
// $path = "$regdir/$myuserid/$servicename/$serviceid";
// if (!encryptFileAES($aesdecrypted, "$path/myimg.webp", "$path/myimg.webp_aes", $error)) return false;
// unlink("$path/myimg.webp")
//
// megj.: Ha a $serviceid=="", akkor a path így fog kinézni
// $path = "$regdir/$myuserid/$servicename";
// 
// III. How to download with key
// ------------------------------
// index.php?srv=system&api=imagedownload&path=$storedpath&k=$keyencrypted'
//
// to encode encryption key: 
// $filekey = generateAesKey(); //Ezzel titkosítjuk a fájlt
// $urlkey = convertToAesKey($siteid)
// $k = encryptTextAES($urlkey, $filekey) //ez megy az url-be
//
// to decode encryption key: 
// $urlkey = convertToAesKey($siteid)
// $filekey = decryptTextAES($urlkey, $k)
//
//*****************************************************************
ob_end_clean();

//*****************************************************************
// Load the request parameter: path
//*****************************************************************
//$debug=true;

loadReqParams("path","k","nocache");

if ($path=="")
{
    echo "No path was specified";
    return;
}

if (!ozstartswith($path,"/")) $path = "/".$path;

$realpath = realpath($datadir.$path);
if ($realpath===false)
{
    $error = "The file to download does not exist on the server";
    if ($debug) $error .= " ".$datadir.$path;
    echo $error;
    return;
}

//*****************************************************************
// Exit if image path is manipulated
//*****************************************************************

$removeafter = false;
$realprefix = realpath($datadir);
if (($realprefix !== false) && !ozstartswith($realpath,$realprefix))
{
    echo "The file is not in the ozeki data directory.";
    return;
}

//*****************************************************************
// Exit if image is not encrypted 
//*****************************************************************
$encryptionrequired = true;

if (ozendswith($realpath,"profile.webp"))
{
    $encryptionrequired = false;
}
else if (ozendswith($realpath,"displayimage.webp"))
{
    $encryptionrequired = false;
}
if ($encryptionrequired && !ozendswith($realpath,"_aes"))
{
    echo "Unencrypted files cannot be downloaded";
    return;
}

//*****************************************************************
// Load the encrypted file and decrypt it using the determined key
//*****************************************************************

$ext = pathinfo($realpath, PATHINFO_EXTENSION);

if ($encryptionrequired) 
{
    $ext = substr($ext,0,strlen($ext)-4);

    if (!isEmpty($k))
    {
        $k = str_replace(" ","+",$k);
        $urlkey = convertToAesKey($siteid);
        $aeskey = decryptTextAES($urlkey, $k);
        if ($aeskey==false)
        {
            echo "Cannot read AES key to decrypt file\r\n";
            return;    
        }
    } 
    else if (!loadAesKeyForService($servicename,$ownerhash,$serviceid,$aeskey,$error))
    {
        echo "Cannot find service AES key to decrypt this file\r\n";
        return;
    }


    $filename = basename($realpath);
    $filetoserve = "$datadir/tmp/".$filename."_dec";

    if (!loadFileAES($aeskey, $realpath, $content, $error))
    {
        echo "Decryption error: $error";
        return;
    }
} 
else
{
    if (!ozreadfile($realpath,$content,$error))
    {
        echo "File read error: $error";
        return;
    }
}

//*****************************************************************
// Serve the file
//*****************************************************************

header('Content-Type: image/'.$ext);
header('Content-Transfer-Encoding: binary');
header('Content-Disposition: inline; filename="'.$filename.'"');
header('Pragma: public');
header("Content-Length: ".strlen($content));

if (isset($nocache)&&$nocache=="true") 
{
    header('Expires: 0');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
} else 
{
    header('Cache-Control: max-age=2592000');
}

ob_clean();
flush();
echo $content;
exit;
?>