<?php
//
//File server for user data
//
// - Minden fájl egy könyvtár
// - Minden fájlt titkosítva tölt fel a user
// - Verzió kezelést használunk
// 
// - /userdata/myvideos/userdata/video1.mp4/meta.json
// - /userdata/myvideos/video1.mp4/file.dat
// - /userdata/myvideos/video1.mp4/versions/250619-173102.aes
//

//******************************************************
// Simple file server actions
//******************************************************
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.downloadfile.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.deletefile.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.uploadfile.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.listdir.php");

//******************************************************
// Versioned file server actions
//******************************************************
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.safety.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.upload.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.list.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.delete.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.download.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.downloadattachment.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.deleteattachment.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.listattachments.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.export.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.import.php");
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.batchdownloadusers.php");

//******************************************************
// Load request
//******************************************************
header('Content-Type: application/json');

if (!isValidSignedInput($userid,$stationid,$req,$action,$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    $resp=json_encode($resp);
    echo $resp;
    http_response_code(200);
    exit;
}

//******************************************************
// Config
//******************************************************

date_default_timezone_set('UTC');
$UPLOAD_DIR = "$regdir/$userid/userdata"; // Set your base upload directory
$ALLOWED_OPERATIONS = ['upload', 'download'];
$MAX_FILE_SIZE = 50 * 1024 * 1024; // 50MB
$ENCRYPT_FILENAMES = false;

//******************************************************
// Safety
//******************************************************

if(!tryChangeUploadDir($req,$UPLOAD_DIR,$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    $resp=json_encode($resp);
    echo $resp;
    http_response_code(200);
    exit;
}

if (!isFileServerRequestSafe($req,$rpath,$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    $resp=json_encode($resp);
    echo $resp;
    http_response_code(200);
    exit;
}

if (!hasAccessToPath($userid,$rpath,"read",$error))
{
    if (isDebug()) $extrainfo = " Path: $userid, $rpath"; else $extrainfo = "";
    ozerror(__FILE__,"Access to path is not allowed. $error $extrainfo",$resp,$error);
    $resp=json_encode($resp);
    echo $resp;
    http_response_code(200);
    exit;
}

//******************************************************
// Return response
//******************************************************

switch ($action)
{
    //******************************************************
    // Simple file server actions
    //******************************************************
    case"uploadfile":
        handlerequest_fileserver_uploadfile($userid,$req,$rpath,$resp);
        break;
    case"deletefile":
        handlerequest_fileserver_deletefile($userid,$req,$rpath,$resp);
        break;
    case"downloadfile":
        handlerequest_fileserver_downloadfile($userid,$req,$rpath,$resp);
        break;
    case"listdir":
        handlerequest_fileserver_listdir($userid,$req,$rpath,$resp);
        break;

    //******************************************************
    // Versioned file server actions
    //******************************************************
    case"upload":
        handlerequest_fileserver_upload($userid,$req,$rpath,$resp);
        break;
    case"list":
        handlerequest_fileserver_list($userid,$req,$rpath,$resp);
        break;   
    case"delete":
        handlerequest_fileserver_delete($userid,$req,$rpath,$resp);
        break;          
    case"download":
        handlerequest_fileserver_download($userid,$req,$rpath,$resp);
        break;
    case"downloadattachment":
        if (handlerequest_fileserver_downloadattachment($userid,$req,$rpath,$resp))
        {
            $mimetype=mime_content_type($resp["path"]);
            if(!$mimetype)$mimetype="application/octet-stream";
            header('Content-Type: '.$mimetype);
            header('Content-Disposition: attachment; filename="'.$resp["filename"].'"');
            header('Content-Length: '.$resp["contentlength"]);
            readfile($resp["path"]);
            exit;
        }
        break;
    case"listattachments":
        handlerequest_fileserver_listattachments($userid,$req,$rpath,$resp);
        break; 
    case"deleteattachment":
        handlerequest_fileserver_deleteattachment($userid,$req,$rpath,$resp);
        break;
    case"export":
        if (handlerequest_fileserver_export($userid, $req, $rpath, $resp)) {
            exit;
        }
        break;
    case "import":
        handlerequest_fileserver_import($userid, $req, $rpath, $resp);
        break;
    case "batchdownloadusers":
        handlerequest_fileserver_batchdownloadusers($userid, $req, $rpath, $resp);
        break;
    default:
        ozerror(__FILE__,"Invalid fileserver action: $action",$resp,$error);
        break;
}

$resp=json_encode($resp);
echo $resp;

?>