<?php
function handlerequest_fileserver_uploadfile($userid,$req,$requestpath,&$resp)
{
    if (!hasAccessToPath($userid,$requestpath,"write",$error))
    {
        $error="User does not have write privileges for this location. $error";
        ozerror(__FILE__,$error,$resp,$error);
        return;
    }

    if (!fileserver_uploadfile($requestpath,$error))
    {
        $error="File upload failed. $error";
        ozerror(__FILE__,$error,$resp,$error);
        return;
    }

    $resp["status"]="OK";
    $resp["errormessage"]="";
}

function fileserver_uploadfile($requestpath,&$error)
{
    global$MAX_FILE_SIZE;
    if (!ozmkdir(dirname($requestpath),$error))
    {
        $error="Could not create directory. $error";
        return false;
    }
    if(!isset($_FILES)||!isset($_FILES["file"]))
    {
        $error="Empty data received.";
        return false;
    }
    $file=$_FILES["file"];
    if($file['size']>$MAX_FILE_SIZE)
    {
        $error="File size exceeds maximum allowed.";
        return false;
    }
    if($file['error']!==UPLOAD_ERR_OK)
    {
        $error="Upload error. ".fileuploaderr2str($file['error']);
        return false;
    }
    if(!move_uploaded_file($file['tmp_name'],$requestpath))
    {
        $error="Could not move uploaded file.";
        return false;
    }
    return true;
}
?>