<?php
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.safety.php");

function handlerequest_fileserver_upload($userid,$req,$requestPath,&$resp)
{
    if (!hasAccessToPath($userid,$requestPath,"write",$error))
    {
        $error="User does not have write privileges for this location. $error";
        ozerror(__FILE__,$error,$resp,$error);
        return false;
    }

    if (!fileServerUpload($userid,$req,$requestPath,$resp,$error))
    {
        $error = "File upload failed. $error";
        ozerror(__FILE__,$error,$resp,$error);
        return false;
    }

    $error = "File upload success. $error";
    $resp["status"]="OK";
    $resp["errormessage"]= $error;
    return true;
}

function fileServerUpload($userid,$req,$requestPath,&$resp, &$error)
{
    global $MAX_FILE_SIZE;

    if (!ozmkdir($requestPath,$error))
    {
        $error = "Could not save content. Could not create directory. $error";
        return false;
    }

    //Save the content if present
    if (isset($req["content"]) && strlen($req["content"])>0)
    {
        if (!ozsavefile("$requestPath/content.dat",$req["content"],$error))
        {
            $error = "Could not save content. Save failed. $error";
            return false;
        }
        $error = "Content saved.";
        return true;
    }
 
    if (!isset($_FILES) || count($_FILES)==0)
    {
        $error = "File upload failed. Empty data received.";
        return false;
    }

    $error = "Uploading files: ".count($_FILES);

    $attachmentsPath = "$requestPath/attachments";
    if (!ozmkdir($attachmentsPath,$error))
    {
        $error = "Could not create attachments directory. $error";
        return false;
    }

    foreach($_FILES as $filename => $file)
    {
        if ($file['size'] > $MAX_FILE_SIZE) 
        {
            $error = 'File size exceeds maximum allowed';
            return false;
        }

        if ($file['error'] !== UPLOAD_ERR_OK) 
        {
            $error = 'Upload error. Code: '.$file['error'].'. Message:'.fileuploaderr2str($file['error']);
            return false;
        }

        $fileTmpPath = $file['tmp_name'];
        $fileName = $file['name'];
        $fileType = $file['type'];

        $destName = sanitizePath($fileName);

        $destFinal = "$attachmentsPath/$destName";
        $error .= "Saving file to: ".$destFinal;

        if (!move_uploaded_file($fileTmpPath, $destFinal)) 
        {
            $error = "Could not move uploaded file";
            return false;
        }
    }

    return true;
}
?>