<?php

function isFileServerRequestSafe($req,&$requestPath,&$error)
{
    global $UPLOAD_DIR,$debug;
    $error = "";
    $requestPath = "";

    if (!ozmkdir($UPLOAD_DIR,$error))
    {
        $error = "Could not create upload directory.";
        return false;
    }

    if (!isset($req["path"]))
    {
        $error = "Path not specified.";
        return false;
    } 

    $requestPath = $req["path"];
    if (!ozstartswith($requestPath,"/"))
    {
        $error = "Path should start with /.";
        return false;
    }

    $requestPath = str_replace('../', '', $requestPath);
    $requestPath = $UPLOAD_DIR.trim($requestPath);
    $requestPath = str_replace("\\","/",$requestPath);
    
    if ($requestPath != sanitizePath($requestPath))
    {
        $error = "Only latin characters and numbers can be used as file or directory names.";
        if ($debug) $error .= " ".$requestPath;
        return false;
    }

    $filename = basename($requestPath);
    if ($error == "" && strlen($filename)<3)
    {
        $error = "File name is too short.";
        return false;
    }

    return true;
}

function sanitizePath($filename) {
    // Convert to UTF-8 if not already
    $filename = mb_convert_encoding($filename, 'UTF-8', 'auto');

    // Replace accented characters with ASCII equivalents
    $filename = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $filename);

    // Remove anything that's not a letter, number, dot, dash, or underscore
    $filename = preg_replace('/[^A-Za-z0-9._\/:-]/', '', $filename);

    return $filename;
}

function encryptPath($path)
{
    $path = str_replace('\\', '/', $path);
    $directories = explode('/', trim($path, '/'));
    $encryptedpath = "";
    foreach ($directories as $dir) 
    {
        $encryptedpath = "/".md5($dir);
    }
    return $encryptedpath;
}

function tryChangeUploadDir($req,&$uploaddir,&$error)
{
    global$regdir,$datadir,$userid;
    $scope=$req["scope"]??"user";
    switch($scope)
    {
        case"user":
            $uploaddir="$regdir/$userid/userdata";
            return true;
        case"service":
            $uploaddir="$datadir/services";
            return true;
        default:
            $error="Invalid scope.";
            return false;
    }
}

//accesstype: "read", "write"

function hasAccessToPath($userid,$path,$accesstype,&$error)
{
    global $regdir,$datadir,$servicesdir;
    //if (isDebug()) error_log("fileserver.inc.safety.php: file access request $userid,$path,$accesstype");
    $path=str_replace("\\","/",$path);
    $path=str_replace("/../","",$path);
    $pathuserdata=str_replace("\\","/","$regdir/$userid/userdata/");
    $pathdataservices=str_replace("\\","/","$datadir/services/");
    if(ozstartswith($path,$pathuserdata)) 
    {
        $error = "";
        //if (isDebug()) error_log("fileserver.inc.safety.php. Access granted. Home dir of $userid");
        return true;
    }

    if(ozstartswith($path,$pathdataservices))
    {
        $tail=str_replace($pathdataservices,"",$path);
        $srvname=substr($tail,0,strpos($tail,"/"));
        if(!serviceExists($srvname)) 
        {
            $error = "Rejected. Service $srvname does not exist.";
            if (isDebug()) error_log("fileserver.inc.safety.php. $error");
            return false;
        }
        if(!file_exists("$servicesdir/$srvname/permissions.php")) 
        {
            $error = "Rejected. $srvname/permissions.php does not exist";
            if (isDebug()) error_log("fileserver.inc.safety.php. $error");
            return false;
        }
        include_once("$servicesdir/$srvname/permissions.php");
        $funcname="hasaccesstopath_$srvname";
        if(!function_exists($funcname)) 
        {
            $error = "Rejected. $srvname/permissions.php is invalid.";
            if (isDebug()) error_log("fileserver.inc.safety.php. $error");
            return false;
        }
        if($funcname($userid,$accesstype,$path)) {
            $error = "";
            return true;
        }
        $error = "Rejected. $srvname/permissions.php denied access.";
        return false;
    }

    $error = "Rejected. User does not have access to the requested path.";
    return false;
}
?>