<?php

function handlerequest_fileserver_listattachments($userid,$req,$requestPath,&$resp)
{
    if(!getreqparamstr($req,"pattern",$pattern,$resp,$error))return false;
    if (!fileServerListAttachments($userid,$pattern,$requestPath,$itemsjson,$error))
    {
        ozerror(__FILE__,$error,$resp,$error);
        return false;
    }

    $error = "";
    $resp["status"]="OK";
    $resp["errormessage"]="";
    $resp["items"]=$itemsjson;
    return true;
}

function fileServerListAttachments($userid, $pattern, $requestPath, &$itemsjson, &$error)
{
    $dir = $requestPath . "/attachments";

    if (!is_dir($requestPath))
    {
        $itemsjson=json_encode([]);
        return true;
    }

    if (!ozlsdir($dir, $files, $dirs, $error))
    {
        $error = "Cannot list items. $error";
        return false;
    }

    $filteredFiles = [];
    foreach ($files as $file)
    {
        if (!fnmatch($pattern, $file)) continue;
        $filteredFiles[] = $file;
    }

    $itemsjson = json_encode($filteredFiles);
    return true;
}

?>