<?php

function handlerequest_fileserver_list($userid,$req,$requestPath,&$resp)
{
    if (!fileServerList($userid,$req,$requestPath,$itemsjson,$error))
    {
        ozerror(__FILE__,$error,$resp,$error);
        return false;
    }

    $error = "";
    $resp["status"]="OK";
    $resp["errormessage"]="";
    $resp["items"]=$itemsjson;
    return true;
}

function fileServerList($userid,$req,$requestPath,&$itemsjson,&$error)
{
    if (!is_dir($requestPath))
    {
        $itemsjson=json_encode([]);
        return true;
    }

    if (!ozlsdir($requestPath,$files,$dirs,$error))
    {
        $error = "Cannot list items. $error";
        return false;
    }

    $itemjsons = [];
    foreach($dirs as $dir)
    {
        if (!ozreadfile("$requestPath/$dir/content.dat",$content,$error)) continue;
        $itemjsons[] = $content;
    }

    $itemsjson=json_encode($itemjsons);
    return true;
}

?>