<?php
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.safety.php");

function handlerequest_fileserver_import($userid, $req, $requestPath, &$resp)
{
    if (!hasAccessToPath($userid,$requestPath,"write",$error))
    {
        $error="User does not have write privileges for this location. $error";
        ozerror(__FILE__,$error,$resp,$error);
        return false;
    }

    if (!fileServerImport($userid, $req, $requestPath, $resp, $error)) {
        $error = "Import failed. Import error. $error";
        if (isDebug()) {error_log("fileserver.inc.import.php: import failed. ".$error);}
        ozerror(__FILE__, $error, $resp, $error);
        return false;
    }

    if (isDebug()) {error_log("fileserver.inc.import.php: import successful. ".$requestPath);}
    $error = "Import success. $error";
    $resp["status"] = "OK";
    $resp["errormessage"] = $error;
    return true;
}


function fileServerImport($userid, $req, $requestPath, &$resp, &$error)
{
    global $MAX_FILE_SIZE,$UPLOAD_DIR;
     if (substr($requestPath, -1) === '/') $requestPath = substr($requestPath,0,strlen($requestPath)-1);

    error_log("Request path:".$requestPath);
    if (!ozmkdir($requestPath, $error)) {
        $error = "Could not create directory: $requestPath. $error";
        return false;
    }

    if (!isset($_FILES) || count($_FILES) === 0) {
        $error = "No file uploaded";
        return false;
    }

    // Get first uploaded file without reset()
    $file = array_values($_FILES)[0];

    if ($file['size'] > $MAX_FILE_SIZE) {
        $error = "File size exceeds maximum allowed";
        return false;
    }

    if ($file['error'] !== UPLOAD_ERR_OK) {
        $error = 'Upload error. Code: ' . $file['error'] .
                 '. Message: ' . fileuploaderr2str($file['error']);
        return false;
    }

    $zipFile = $file['tmp_name'];
    $zip = new ZipArchive();

    if ($zip->open($zipFile) !== true) {
        $error = "Could not open zip file";
        return false;
    }

    // Manually extract (for Windows path compatibility)
    for ($i = 0; $i < $zip->numFiles; $i++) {
        $entry = $zip->getNameIndex($i);

        // Normalize Windows paths to /
        $fixedEntry = str_replace('\\', '/', $entry);
        if (substr($UPLOAD_DIR, -1) === '/')
            $relativeRequestPath = substr($requestPath,strlen($UPLOAD_DIR)+0);
        else 
            $relativeRequestPath = substr($requestPath,strlen($UPLOAD_DIR)+1);
        //if (isDebug()) error_log("fileserver.inc.import.php: UPLOAD_DIR: ".$UPLOAD_DIR);
        //if (isDebug()) error_log("fileserver.inc.import.php: Request path: ".$requestPath);
        //if (isDebug()) error_log("fileserver.inc.import.php: Relative request path: ".$relativeRequestPath);
        //if (isDebug()) error_log("fileserver.inc.import.php: Zip entry: ".$fixedEntry);
        if (isset($req["scope"]) && ($req["scope"]=="service"))
        {
            //Remove service name from relative path
             $pos = strpos($relativeRequestPath, '/');
             if ($pos !== false) $relativeRequestPath = substr($relativeRequestPath, $pos + 1);
             //if (isDebug()) error_log("fileserver.inc.import.php: Relative request path for service: ".$relativeRequestPath);
        }
        if (ozstartswith($fixedEntry,$relativeRequestPath)) {
            if (isDebug()) error_log("fileserver.inc.import.php: Fixing entry: ".$fixedEntry);
            $fixedEntry = substr($fixedEntry,strlen($relativeRequestPath)+1);
        }
        //if (isDebug()) error_log("fileserver.inc.import.php: Fixed entry: ".$fixedEntry);

        $targetPath = rtrim($requestPath, '/') . '/' . $fixedEntry;

        // Ensure directory exists
        $dir = dirname($targetPath);
        if (!is_dir($dir)) {
            mkdir($dir, 0775, true);
        }

        // Skip directory entries
        if (substr($entry, -1) === '/') {
            continue;
        }

        $content = $zip->getFromIndex($i);
        file_put_contents($targetPath, $content);
    }

    $zip->close();
    return true;
}

?>