<?php
include_once("$dirprefix/ozekiservices/system/api/fileserver/fileserver.inc.safety.php");

function handlerequest_fileserver_export($userid, $req, $requestPath, &$resp)
{
    if (!fileServerExport($userid, $req, $requestPath, $resp, $error)) {
        $error = "Export failed. $error";
        ozerror(__FILE__, $error, $resp, $error);
        return false;
    }

    $error = "Export success. $error";
    $resp["status"] = "OK";
    $resp["errormessage"] = $error;
    return true;
}

function fileServerExport($userid, $req, $requestPath, &$resp, &$error)
{

    if (substr($requestPath, -1) === '/') $requestPath = substr($requestPath,0,strlen($requestPath)-1);

    if (!is_dir($requestPath)) {
        $error = "Directory does not exist: $requestPath";
        return false;
    }

    $dirName = basename($requestPath);
    $zipFile = tempnam(sys_get_temp_dir(), 'export_') . '.zip';
    
    $zip = new ZipArchive();
    if ($zip->open($zipFile, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
        $error = "Could not create zip file";
        return false;
    }

    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($requestPath, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::SELF_FIRST
    );

    foreach ($iterator as $fileInfo) {
        $filePath = $fileInfo->getPathname();
        $relativePath = $dirName . '/' . substr($filePath, strlen($requestPath) + 1);
        
        if ($fileInfo->isDir()) {
            $zip->addEmptyDir($relativePath);
        } else {
            $zip->addFile($filePath, $relativePath);
        }
    }

    $zip->close();

    header('Content-Type: application/zip');
    header('Content-Disposition: attachment; filename="' . $dirName . '.zip"');
    header('Content-Length: ' . filesize($zipFile));
    
    readfile($zipFile);
    unlink($zipFile);
    
    exit;
}
?>