<?php
function handlerequest_fileserver_deletefile($userid,$req,$requestpath,&$resp)
{
    if (!hasAccessToPath($userid,$requestpath,"write",$error))
    {
        $error="User does not have write privileges for this location. $error";
        ozerror(__FILE__,$error,$resp,$error);
        return;
    }

    if (!fileserver_deletefile($requestpath,$error))
    {
        $error="File delete failed. $error";
        ozerror(__FILE__,$error,$resp,$error);
        return;
    }

    $resp["status"]="OK";
    $resp["errormessage"]="";
}

function fileserver_deletefile($requestpath,&$error)
{
    global$MAX_FILE_SIZE;
    if(!file_exists($requestpath))
    {
        return true;
    }
    if(!is_readable($requestpath))
    {
        $error="Could not access file for deletion. Permission denied.";
        return false;
    }
    if(!unlink($requestpath))
    {
        $error="Permission denied or file is in use.";
        return false;
    }
    return true;
}
?>