<?php
function handlerequest_fileserver_deleteattachment($userid, $req, $requestPath, &$resp)
{
    if (!hasAccessToPath($userid,$requestPath,"write",$error))
    {
        $error="User does not have write privileges for this location. $error";
        ozerror(__FILE__,$error,$resp,$error);
        return false;
    }

    if (!fileServerDeleteAttachment($userid, $req, $requestPath, $resp, $error)) {
        ozerror(__FILE__, $error, $resp, $error);
        return false;
    }
    $error = "";
    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    return true;
}

function fileServerDeleteAttachment($userid, $req, $path, &$resp, &$error)
{
    global $MAX_FILE_SIZE, $ENCRYPT_FILENAMES;

    $fileName = basename($path);
    $dirname = dirname($path);
    $f = $dirname . "/attachments/" . $fileName;

    if (!file_exists($f)) {
        $error = "";
        $resp["filename"] = $fileName;
        $resp["status"] = "OK";
        return true;
    }
    
    if (!is_readable($f)) {
        $error = "Cannot access file for deletion. Permission denied.";
        return false;
    }
    
    if (!unlink($f)) {
        $error = "Failed to delete file. Permission denied or file is in use.";
        return false;
    }

    $error = "";
    $resp["filename"] = $fileName;
    $resp["status"] = "OK";
    return true;
}
?>