<?php

function handlerequest_fileserver_delete($userid,$req,$requestPath,&$resp)
{
    if (!hasAccessToPath($userid,$requestPath,"write", $error))
    {
        $error="User does not have write privileges for this location. $error";
        ozerror(__FILE__,$error,$resp,$error);
        return false;
    }

    if (!fileServerDelete($userid,$req,$requestPath,$resp,$error))
    {
        ozerror(__FILE__,$error,$resp,$error);
        return false;
    }

    $error = "";
    $resp["status"]="OK";
    $resp["errormessage"]="";
    return true;
}

function fileServerDelete($userid,$req,$requestPath,&$resp, &$error)
{
    global $MAX_FILE_SIZE,$ENCRYPT_FILENAMES;

    if (!isset($req["items"]) || strlen($req["items"])<1)
    {
        $error = "Could not delete items. Empty item list provided.";
        return false;
    }

    $itemlist = json_decode($req["items"]);

    if (!is_array($itemlist) || count($itemlist)==0)
    {
        $error = "Could not delete items. Item list is empty.";
        return false;
    }

    foreach($itemlist as $dir)
    {
        if (strlen($dir)<1) continue;
        if (!is_dir("$requestPath/$dir")) continue;
        deleteDirectory("$requestPath/$dir");
    }

    $error = "";
    $resp["status"]="OK";
    $resp["errormessage"]="";
    $resp["items"]= $req["items"];
    return true;
}

function deleteDirectory($dir) {
    if (!file_exists($dir)) return true;
    if (!is_dir($dir)) return unlink($dir);

    foreach (scandir($dir) as $item) {
        if ($item === '.' || $item === '..') continue;
        $path = $dir . DIRECTORY_SEPARATOR . $item;
        if (is_dir($path)) {
            deleteDirectory($path);
        } else {
            unlink($path);
        }
    }

    return rmdir($dir);
}



?>