<?php
function handlerequest_fileserver_batchdownloadusers($userid, $req, $requestPath, &$resp)
{
    if(!isDecisionMaker()) {
        $errorMessage = "Permission denied.";
        ozerror(__FILE__, $errorMessage, $resp, $errorMessage);
        return false;
    }

    if(!getreqparamstr($req, "path", $path, $resp, $error)) return false;
    if (!fileServerBatchDownloadUsers($userid, $req, $path, $itemsjson, $error)) {
        ozerror(__FILE__, $error, $resp, $error);
        return false;
    }

    $error = "";
    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    $resp["items"] = $itemsjson;
    return true;
}

function fileServerBatchDownloadUsers($userid, $req, $path, &$itemsjson, &$error)
{
    global $regdir;

    if (!ozlsdir($regdir, $files, $dirs, $error))
    {
        $error = "Cannot list directories. $error";
        return false;
    }

    $userHistories = [];
    foreach ($dirs as $dir)
    {
        $filePath = $regdir."/".$dir."/". "userdata".$path;
        if (!ozreadfile($filePath, $content, $error)) continue;
        $userHistories[] = [ "username" => getNick($dir), "userid" => $dir, "content" => $content ];
    }

    $itemsjson = json_encode($userHistories);
    return true;
}

?>