<?php
//*****************************************************************
// File download server
//
// I. Without key (key discovery will take place)
// --------------
// index.php?owpn=$page_upload_filedownload&nicename=$nicename&path=$storedpath'
// http://localhost/ozeki/index.php?owpn=101201&nicename=test.pdf&
// path=%2Fregistrations%2F4e80164bd5747b42dd0a0bb151efa6ca%2Finbox%2Fattachments%2FjqPgEiSnQH_rsa&nocache=14Cjf6jCUz
//
// II. With key
// --------------
// index.php?owpn=$page_upload_filedownload&nicename=$nicename&path=$storedpath&k=$keyencrypted'
//
// to encode encryption key: 
// $filekey = generateAesKey(); //Ezzel titkosítjuk a fájlt
// $urlkey = convertToAesKey($mypassword)
// $keyencrypted = encryptTextAES($urlkey, $filekey) //ez megy az url-be
// 
// to decode encryption key: 
// $urlkey = convertToAesKey($mypassword)
// $filekey = decryptTextAES($urlkey, $keyencrypted)
//
//*****************************************************************
include_once "$sysdir/base/sessions.php";
include_once "$sysdir/authentication/login.inc.php";
include_once "$sysdir/authentication/loginsession.php";

if (!isUserLoggedIn($error)) {
	echo "<h1>No user is logged on. Please login first.</h1>";
	exit;
}

//*****************************************************************
// Load the request and serve the file
//*****************************************************************

//$nicename = $_REQUEST['nicename'];
//$path = $_REQUEST['path'];
loadReqParams("nicename","path","k");

if ($nicename=="")
{
    echo "No file name was specified";
    return;
}

if ($path=="")
{
    echo "No path was specified";
    return;
}

if (!ozstartswith($path,"/")) $path = "/".$path;

//$debug = true;
$p = $datadir.$path;
$realpath = realpath($p);
var_dump($p);
if ($realpath===false)
{
    $error = "The file to download does not exist on the server";
    if ($debug) $error .= " ".$realpath;
    echo $error;
    return;
}

//*****************************************************************
// Prepare file for download / security
//*****************************************************************

$removeafter = false;
$realprefix = realpath($datadir);
if (($realprefix !== false) && !ozstartswith($realpath,$realprefix))
{
    echo "The file is not in the ozeki data directory.";
    return;
}

if (!ozendswith($realpath,"_aes") && !ozendswith($realpath,"_rsa"))
{
    echo "Unencrypted files cannot be downloaded";
    return;
}

//http://localhost/ozeki/index.php?owpn=101201&nicename=test.pdf&
//path=%2Fregistrations%2F4e80164bd5747b42dd0a0bb151efa6ca%2Finbox%2Fattachments%2FjqPgEiSnQH_rsa&nocache=14Cjf6jCUz
$myprefix = "/registrations/".$myuserid;
$foreignfile = !ozstartswith($path,$myprefix);
//owner
$ownerhash = substr($path,strlen("/registrations/"),strlen($myuserid));

//service name
$servicepath = substr($path,strlen($myprefix)+1);
$posnext = strpos($servicepath,"/");
if ($posnext<1)
{
    echo "You can only download files saved by services";
    return;
}
$servicename = substr($servicepath,0,$posnext);

//service id
$tail = substr($servicepath,strlen($servicename)+1);
$posnext = strpos($tail,"/");
$serviceid = substr($tail,0,$posnext);
if (!ismd5($serviceid)) $serviceid="";

$privatekeyfile = "$regdir/$userid/$servicename/privatekey.txt";

//*****************************************************************
// Prepare file for download / encrypted
//*****************************************************************

$filetoserve = $realpath;
if (ozendswith($filetoserve,"_aes"))
{
    if (isset($k) && !isEmpty($k))
    {
        $urlkey = convertToAesKey($mypassword);
        $aeskey = decryptTextAES($urlkey, $k);
        if ($aeskey==false)
        {
            echo "Cannot read AES key to decrypt file\r\n";
            return;    
        }
    } 
    else if (!loadAesKeyForService($servicename,$ownerhash,$serviceid,$aeskey,$error))
    {
        echo "Cannot find service AES key to decrypt this file\r\n";
        return;
    }

    $destpath = "$datadir/tmp/".basename($realpath)."_dec";
    if (!decryptFileAES($aeskey, $realpath, $destpath, $error))
    {
        echo "Decryption error: $error";
        return;
    }

    $filetoserve = $destpath;
    $removeafter = true;
}

if (ozendswith($filetoserve,"_rsa"))
{
    $fileowner = substr($path,strlen("/registrations")+1,32);

    if ($fileowner==$myuserid)
    {
        $servicePrivateKey = $myprivatekey;
    } 
    else if (!ozloadrsaprivatekeyof($fileowner,$servicePrivateKey,$error))
    {
        $error = "Cannot download file. The security key for this file is not shared with me.";
        return false;
    }

    /*
    $privatekeyfile = "$regdir/$userid/$servicename/privatekey.txt";
    if (!file_exists($privatekeyfile))
    {
        echo "Cannot find service private key to decrypt this file";
        return;
    }
    $encrypted = file_get_contents($privatekeyfile);
    if (!decryptTextRSAAES($myprivatekey,$encrypted,$servicePrivateKeyPEM,$error))
    {
        echo "Cannot decript private key";
        return;
    }
    importRsaPrivateKeyFromPEM($servicePrivateKeyPEM, null, $servicePrivateKey, $servicePublicKey,$error);
    if (!is_resource($servicePrivateKey) && !is_object($servicePrivateKey))
    {
        echo "Cannot load service private key";
        return;
    }
    */

    $destpath = "$datadir/tmp/".basename($realpath)."_dec";
    if (!decryptFileRSAAES($servicePrivateKey, $realpath, $destpath, $error))
    {
        echo "Decryption error: $error";
        return;
    }
    $filetoserve = $destpath;
    $removeafter = true;
}

//*****************************************************************
//Serve the file
//*****************************************************************

header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="'.basename($nicename).'"');
header('Content-Transfer-Encoding: binary');
header('Expires: 0');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Pragma: public');
header("Content-Length: ".filesize($filetoserve));

ob_clean();
flush();
readfile($filetoserve);
if ($removeafter) unlink($filetoserve);
exit;

?>