<?php
//*****************************************************************
//Serve the file
// $file = urlencode("/vir/attachments/app.svg")
// http://localhost/ozeki/index.php?srv=system&api=attachmentdownload&path=$file
// http://localhost/ozeki/index.php?srv=system&api=attachmentdownload&path=%2Fvir%2Fattachments%2Fapp.svg
//*****************************************************************

loadReqParams("path");

if ($path=="")
{
    echo "No path was specified";
    return;
}


$realprefix = realpath($servicesdir);
if ($realprefix === false || $realprefix=="")
{
    echo "The services directory could not be found.";
    return;
}

$fullpath = $realprefix."/".$path;
$realpath = realpath($fullpath);

if (!ozstartswith($realpath,$realprefix))
{
    echo "The file is not in the ozeki services directory.";
    return;
}

$realpath = str_replace("\\","/",$realpath);

if (!preg_match('|.*[/]ozekiservices[/][^/][^/]*[/]attachments[/].*|',$realpath))
{
    echo "The file is not in the ozeki services attachments directory ($realpath).";
    return;
}

if (!file_exists($realpath))
{
    echo "File not found.";
    return;
}

function getMimeTypeFromExtension($filename) {
    // A mapping of file extensions to MIME types.
    $mimeTypes = [
        // Text files
        'txt'  => 'text/plain',
        'html' => 'text/html',
        'htm'  => 'text/html',
        'css'  => 'text/css',
        'js'   => 'application/javascript',
        'json' => 'application/json',
        'xml'  => 'application/xml',
        // Images
        'png'  => 'image/png',
        'jpg'  => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'gif'  => 'image/gif',
        'bmp'  => 'image/bmp',
        'ico'  => 'image/vnd.microsoft.icon',
        'svg'  => 'image/svg+xml',
        // Archives
        'zip'  => 'application/zip',
        'rar'  => 'application/x-rar-compressed',
        'tar'  => 'application/x-tar',
        'gz'   => 'application/gzip',
        // Audio/Video
        'mp3'  => 'audio/mpeg',
        'wav'  => 'audio/wav',
        'mp4'  => 'video/mp4',
        'mov'  => 'video/quicktime',
        // Documents
        'pdf'  => 'application/pdf',
        'doc'  => 'application/msword',
        'docx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'xls'  => 'application/vnd.ms-excel',
        'xlsx' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'ppt'  => 'application/vnd.ms-powerpoint',
        'pptx' => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
    ];

    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));

    // Return the MIME type if the extension exists in our mapping.
    if (array_key_exists($ext, $mimeTypes)) {
        return $mimeTypes[$ext];
    }

    // Fallback to a generic binary stream if unknown.
    return 'application/octet-stream';
}

$contentType = getMimeTypeFromExtension($realpath) ;

header('Content-Description: File Transfer');
header('Content-Type: '.$contentType);
header('Content-Disposition: attachment; filename="'.basename($realpath).'"');
header('Content-Transfer-Encoding: binary');
header('Expires: 0');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Pragma: public');
header("Content-Length: ".filesize($realpath));

readfile($realpath);
?>