<?php
include_once("$sysdir/navbar/navbar.php");
include_once("$servicesdir/subscriptions/common.php");

//**********************************************
// Print service link
//**********************************************

function printNavbarLinkForService($servicename)
{
    global $servicedescription,$dirprefix,$debug;

    if (!isset($servicedescription[$servicename]["fullname"])) return "";

    $fullname = $servicedescription[$servicename]["fullname"];
    $desc = $servicedescription[$servicename]["description"];
    $home = $servicedescription[$servicename]["home"];
    $icon = $servicedescription[$servicename]["icon"];

    if (array_key_exists("navbarlink_label",$servicedescription[$servicename]))
    {
        $fullname = $servicedescription[$servicename]["navbarlink_label"];
    }

    $iconpath = $dirprefix.$icon;
	if (!file_exists($iconpath))
	{
		$icon = "/ozekiservices/subscriptions/attachments/appdefault.svg";
	}

    global $$home;
    if ($$home=="") return "";

    return navbarPageLink($home,"",$fullname,$icon);
}

//************************************************************
// Is navbar link visible
// $servicename = "sales";
// $viewmode = "servicecustomer","serviceprovider","servicemanager","serviceowner"
//************************************************************

function isNavbarLinkVisible($servicename,$viewmode="servicecustomer")
{
    global $servicedescription;
    if (!array_key_exists("navbarlink",$servicedescription[$servicename])) return true;

    if (array_key_exists("navbarlink_visible",$servicedescription[$servicename])) return $servicedescription[$servicename]["navbarlink_visible"];

    //Displaying links for service owners
    if ($viewmode=="serviceowner")
    {
        if (!array_key_exists("serviceowner",$servicedescription[$servicename])) 
        {
            return false;
        }

        if (!$servicedescription[$servicename]["serviceowner"])
        {
            return false;
        }

        $ret = $servicedescription[$servicename]["navbarlink"];
        return $ret;
    }

    //Displaying links for service managers
    if ($viewmode=="servicemanager")
    {
        if (!array_key_exists("servicemanager",$servicedescription[$servicename])) 
        {
            return false;
        }

        if (!$servicedescription[$servicename]["servicemanager"])
        {
            return false;
        }

        $ret = $servicedescription[$servicename]["navbarlink"];
        return $ret;
    }
    
    //Displaying links for service providers
    if ($viewmode=="serviceprovider")
    {
        if (!array_key_exists("serviceprovider",$servicedescription[$servicename])) 
        {
            return false;
        }

        if (!$servicedescription[$servicename]["serviceprovider"])
        {
            return false;
        }

        if (array_key_exists("navbaradmin",$servicedescription[$servicename]) && isDecisionMaker()) 
        {
            return $servicedescription[$servicename]["navbaradmin"];
        }

        return $servicedescription[$servicename]["navbarlink"];
    } 

    //Displaying links for not service provider

    if (array_key_exists("servicemanager",$servicedescription[$servicename]) && $servicedescription[$servicename]["servicemanager"]) 
    {
        return false;
    }

    if (array_key_exists("serviceprovider",$servicedescription[$servicename]) && $servicedescription[$servicename]["serviceprovider"]) 
    {
        return false;
    }

    if (array_key_exists("navbaradmin",$servicedescription[$servicename]) && isDecisionMaker()) 
    {
        return $servicedescription[$servicename]["navbaradmin"];
    }

    return $servicedescription[$servicename]["navbarlink"];
    
}

//************************************************************
// Print customer services
//************************************************************
function  createNavbarDashboard()
{
    global $myuserid, $servicedescription;

    if (!loadServiceDescriptions($myuserid,$installed, $error)) return;

    $navitemMyServices = "";

    //************************************************************
    // Print service I use
    //************************************************************
    $navitemMyUsedServices = "";
    $serviceuser = false;
    foreach ($installed as $servicename) 
    {
        if (!isNavbarLinkVisible($servicename,"servicecustomer")) continue;
        if (!array_key_exists("serviceowner",$servicedescription[$servicename])) continue;
        if ($servicedescription[$servicename]["serviceowner"]==true) continue;
        if (!array_key_exists("servicemanager",$servicedescription[$servicename])) continue;
        if ($servicedescription[$servicename]["servicemanager"]==true) continue;
        $serviceuser = true;
        $navitemMyUsedServices .= printNavbarLinkForService($servicename);
    }

    if ($serviceuser)
    {
        $navitemMyServices = '<li class="nav-item">';
        $navitemMyServices .= navbarSectionTitle("My services");
        $navitemMyServices .= navbarDivider();
        $navitemMyServices .= $navitemMyUsedServices;
        $navitemMyServices .= '</li>';
    }

    //************************************************************
    // Print service I provider
    //************************************************************
    $navitemMyServiceOfferings = "";
    $serviceprovider = false;
    foreach ($installed as $servicename) 
    {
        if (!isNavbarLinkVisible($servicename,"serviceprovider")) continue;
        $serviceprovider = true;
        $navitemMyServiceOfferings .= printNavbarLinkForService($servicename);
    }

    if ($serviceprovider) 
    {
        $navitemMyServices .= '<li class="nav-item">';
        $navitemMyServices .= navbarSectionTitle("Services I provide");
        $navitemMyServices .= navbarDivider();
        $navitemMyServices .= $navitemMyServiceOfferings;
        $navitemMyServices .= '</li>';
    }

    //************************************************************
    // Print services I administer
    //************************************************************
    $navitemMyServiceOfferings = "";
    $serviceadmin = false;
    foreach ($installed as $servicename) 
    {
        if (!isNavbarLinkVisible($servicename,"servicemanager")) continue;
        $serviceadmin = true;
        $navitemMyServiceOfferings .= printNavbarLinkForService($servicename);
    }

    if ($serviceadmin) 
    {
        $navitemMyServices .= '<li class="nav-item">';
        $navitemMyServices .= navbarSectionTitle("Services I manage");
        $navitemMyServices .= navbarDivider();
        $navitemMyServices .= $navitemMyServiceOfferings;
        $navitemMyServices .= '</li>';
    }

    //************************************************************
    // Print services I owner
    //************************************************************
    $navitemMyServiceOfferings = "";
    $serviceadmin = false;
    foreach ($installed as $servicename) 
    {
        if (!isNavbarLinkVisible($servicename,"serviceowner")) continue;
        $serviceadmin = true;
        $navitemMyServiceOfferings .= printNavbarLinkForService($servicename);
    }

    if ($serviceadmin) 
    {
        $navitemMyServices .= '<li class="nav-item">';
        $navitemMyServices .= navbarSectionTitle("Services I own");
        $navitemMyServices .= navbarDivider();
        $navitemMyServices .= $navitemMyServiceOfferings;
        $navitemMyServices .= '</li>';
    }

    return $navitemMyServices;
}

//************************************************************
// Register navbar
//************************************************************

$navbar["subscriptions"] = "createNavbarDashboard";
$navbar_dashboard[] = "createNavbarDashboard";// $navitemMyServices;
//exit;
?>