<?php
include_once("$servicesdir/subscriptions/pages/changeversion/changeversion.inc.php");

global $myservicename,$preferredversion,$myserviceuser;
loadReqParams("myservicename","preferredversion","myserviceuser");

//***************************************************************
// Load request parameters
//***************************************************************

if (!isset($myservicename) || isempty($myservicename) || !serviceExists($myservicename))
{
    echo card("Change version");
    echo displayError("Service error", "The service was not found. Version change is not possible.");
    echo cardend();
    return;
}


//***************************************************************
// Process the form
//***************************************************************
$fullname = $servicedescription[$myservicename]["fullname"];
if (!userExists($myserviceuser)) $myserviceuser = $myuserid;
if (!isDecisionMaker()) $myserviceuser = $myuserid;

if (!getServiceVersion($myservicename, $userid, $currentversion, $error))
{
    echo card("Change version");
    echo displayError("Service error", "Could version change not possible. $error.");
    echo cardend();
    return;
}

if (isset($preferredversion))
{
    if (!changeServiceVersion($myservicename,$myserviceuser,$currentversion, $preferredversion,$error))
    {
        echo card("Change version");
        echo displayError("Service error", "Could not change version. $error.");
        echo cardend();
        return;
    } else
    {
        echo card("Change version");
        echo displaySuccess("Service update", "Service '$fullname' is now running on version '". getVersionName($preferredversion)."'.");
        echo cardend();
        return;
    }
}

//***************************************************************
// Display form
//***************************************************************
$combo = getVersionCombo($myservicename, $currentversion);

echo card("Change version");
echo <<<TEXTEND
<P>
You may change the version of the $fullname service by selecting from the
list of available versions. To use the default version, pleae select
'Use default'.
</P>

<FORM action="index.php" method="GET">
<input type='hidden' name='owpn' value='page_subscriptions_changeversion'>
<input type='hidden' name='myservicename' value='$myservicename'>

<p>
<b>Service name:</b><br>
$fullname<br>
</p>

<p>
<b>Preferred version:</b><br>
$combo<br>
</p>

<input type="submit" class="btn btn-primary mt-3" value="Save">
</FORM>

TEXTEND;
echo cardend();

?>