<?php
//***************************************************************
// Support functions
//***************************************************************
function getVersionName($vernum)
{
    if ($vernum == "dev") return "Release candidate";
    if ($vernum == "default") return "Stable";
    if ($vernum == "kamikaze") return "Experimental";
    return $vernum;
}

function getVersionCombo($servicename, $currentversion)
{
    global $servicedescription;

	if (!isset($servicedescription[$servicename]["versions"]["published"]) ||
	    !is_array($servicedescription[$servicename]["versions"]["published"])) 
    return "Version change is not allowed.";

    $available = $servicedescription[$servicename]["versions"]["published"];

    $ret = "<select name='preferredversion'>";
    
    if ("default"==$currentversion) $selected = "selected"; else $selected = "";
    $ret .= "<option value='default' $selected>". getVersionName("default")."</option>";
    
    if ("dev"==$currentversion) $selected = "selected"; else $selected = "";
    $ret .= "<option value='dev' $selected>". getVersionName("dev")."</option>";

    if ("kamikaze"==$currentversion) $selected = "selected"; else $selected = "";
    $ret .= "<option value='kamikaze' $selected>". getVersionName("kamikaze")."</option>";

    foreach($available as $av)
    {
        if ($av==$currentversion) $selected = "selected"; else $selected = "";
        $ret .= "<option value='$av' $selected>$av</option>";
    }
    $ret .= "</select>";
    return $ret;
}

function getServiceVersion($servicename, $userid, &$serviceversion, &$error)
{
    global $regdir;
    if (!serviceExists($servicename)) 
    {
        $error = "Cannot find version file. Service does not exists.";
        return false;
    }

    if (!userExists($userid))
    {
        $error = "Cannot find version user. User does not exists.";
        return false;
    }

    $dir = "$regdir/$userid/subscriptions/versions";
    if (!is_dir($dir) && !ozmkdir($dir,$error))
    {
        $error = "Cannot create version directory for user. $error";
        return false;
    }

    $file = "$dir/$servicename.txt";
    if (!ozreadfile($file,$content,$error))
    {
        $serviceversion = "default";
        return true;
    }

    global $servicedescription;
    if (!in_array($content,$servicedescription[$servicename]["versions"]["published"]) &&
        $content!='default' &&  $content!='dev' &&  $content!='kamikaze')
    {
        $serviceversion = "default";
        return true;
    }

    $serviceversion = trim($content);
    return true;
}

function setServiceVersion($servicename, $userid, $serviceversion, &$error)
{
    global $regdir;

    if (!serviceExists($servicename)) 
    {
        $error = "Cannot find version file. Service does not exists.";
        return false;
    }

    if (!userExists($userid))
    {
        $error = "Cannot find version user. User does not exists.";
        return false;
    }

    $dir = "$regdir/$userid/subscriptions/versions";
    if (!is_dir($dir) && !ozmkdir($dir,$error))
    {
        $error = "Cannot create version directory for user. $error";
        return false;
    }

    $file = "$dir/$servicename.txt";
    if (!ozsavefile($file,$serviceversion,$error))
    {
        $error = "Cannot save service version";
        return false;
    }

    $error = "";
    return true;
}

function changeServiceVersion($servicename,$userid, $currentversion, $newversion,&$error)
{
    global $servicedescription;

	if (!isset($servicedescription[$servicename]["versions"]["published"]) ||
	    !is_array($servicedescription[$servicename]["versions"]["published"])) 
    {
        $error = "Version change is not possible.";
        return false;
    }

    if ($currentversion == $newversion)
    {
        $error = "You already use version '$currentversion'. Version change is not neccessary.";
        return false;
    }

    if (!setServiceVersion($servicename, $userid, $newversion, $error))
    {
        $error = "You change request failed. $error";
        return false;
    }

    $error = "";
    return true;
}


?>