<?php
//**********************************************
// Top dash cards for service I provide
//**********************************************
include_once("$dirprefix/ozekiservices/subscriptions/common.dashcard.php");
include_once("$dirprefix/ozeki/sys/base/layout.php");
include_once("$dirprefix/ozekiservices/dashboard/dashcards/dashcard_functions.php");

function printDashCardServicesIOwn($userid)
{
    if (!loadInstalledServices($userid,$installed,$error)) return "";
    foreach ($installed as $servicename) 
    {
        includeDescription($servicename,$error);
    }
    usort($installed, "cmpSubscriptionOrder");

    $cnt=0;
    $icons = "";
    foreach ($installed as $servicename) 
    {
        if (!isQuickLinkVisible($servicename)) continue;
		if (!isServiceOwner($servicename)) continue;
        $icons .= printServiceIconCard($servicename);
        $cnt++;
    }
    if ($cnt==0) return "";
    
    $ret = dashcardHeader("Owner oversight","#87d5cc","subscriptions_owneroversight_1");
	$ret .= "<div class='float-start'>";
    $ret .= $icons;
	$ret .= "</div>";
	$ret .= dashcardFooter("subscriptions_owneroversight_1");

	return $ret;
}

//**********************************************
// Register dash card
//**********************************************
$dashcards["subscriptions_servicesiown"]["display"] = "printDashCardServicesIOwn";
$dashcards["subscriptions_servicesiown"]["title"] = "Services I own";
$dashcards["subscriptions_servicesiown"]["order"] = 90;

?>
