<?php
//**********************************************
// create card
//**********************************************
function datacard_install_service($userhash)
{
	global $serviceinstallresult,$owpn,$servicesdir,$servicedescription;
	include_once("$servicesdir/subscriptions/common.php");
	include_once("$servicesdir/subscriptions/installservice.action.php");
	includeDescriptions();
	loadInstalledServices($userhash,$installed,$error);

	$srvlist = "";
	$first = true;
	if (is_array($installed)) 
	{
		foreach($installed as $srv)
		{
			$f = $servicedescription[$srv]["fullname"];
			$srvlist .= "<span>";
			if (!$first) $srvlist .= " | ";
			$first = false;
			$delurl = "index.php?owpn=$owpn&myserviceaction=uninstallozekiservice&myservicename=$srv&myserviceuser=$userhash&userid=$userhash";
			$delimg = "<img src='/ozekiservices/subscriptions/attachments/del.svg' width='12'>";
			$dellink = "<a href=\"$delurl\" onclick=\"return confirm('Are you sure you want to uninstall this service: $srv');\">$delimg</a>";
			$srvlist .= "$f $dellink";
			$srvlist .= "</span>";
		}
	}

	if (!isEmpty($srvlist))
	{
		$srvlist = "<b>Installed:</b><BR>".$srvlist;
	}

	$notinstalledCombo = comboServicesNotInstalled($userhash,"myservicename");

	$cardbody = <<<FORMEND
	<div>
		$serviceinstallresult
		<form action="index.php" method="post">
		<input type="hidden" name="owpn" value="$owpn">
		<input type="hidden" name="myserviceaction" value="installozekiservice">
		<input type="hidden" name="myserviceuser" value="$userhash">
		<input type="hidden" name="userid" value="$userhash">
		<div class="mb-0 mt-2"><b>Install service:</b></div>
		<div class="mb-0">$notinstalledCombo</div>
		<button class="btn btn-primary mt-1" name="random" type="submit">Install service</button>
		</form>
	</div>
FORMEND;
	

$card =<<<CARD
	<div class="col-md-6 col-xxl-3">
		<div class="card h-md-100 ecommerce-card-min-width" style="background-color: #acffa0;">
			<div class="card-header pb-0">
				<h3>Install service</h3>
			</div>
			<div class="card-body d-flex flex-column bg-light">
				<span>$srvlist</span>
				$cardbody
			</div>
		</div>
	</div>
CARD;

	return $card;
}

//**********************************************
// register card
//**********************************************
$userinfocards["subscriptions_serviceinstall"]["display"] = "datacard_install_service";

?>