<?php
//**********************************************
// Top dash cards for service I use
//**********************************************
include_once("$dirprefix/ozekiservices/subscriptions/common.dashcard.php");

function printDashCardServicesIUse($userid)
{
    $quickInstallButton = quickInstall();

    if (!loadInstalledServices($userid,$installed,$error)) return "";
    foreach ($installed as $servicename) 
    {
        includeDescription($servicename,$error);
    }
    usort($installed, "cmpSubscriptionOrder");

    $icons = "";
    foreach ($installed as $servicename) 
    {
        if (!isQuickLinkVisible($servicename)) continue;
		if (isServiceProvider($servicename)) continue;
        if (isServiceManager($servicename)) continue;
        if (isServiceOwner($servicename)) continue;
        $icons .= printServiceIconCard($servicename);
    }

$iconCard = <<<ICONCARDEND
    <div class="card mb-3" style="background-color: #c9daff;">
        <div class="card-header">
            <h3 class="m-0 me-3 float-start">Favorites</h3>
            $quickInstallButton
        </div>
        <div class="card-body bg-light p-2">
            <div class="g-1">
            $icons
            </div>
        </div>
    </div>
ICONCARDEND;
    
    return $iconCard;

}


//**********************************************
// Register dash card
//**********************************************
$dashcardstop[] = "printDashCardServicesIUse";
?>