<?php


//**************************************************************
// Is subscribed
//**************************************************************

function isinfilelist($file, $rec)
{
    $records = array();
    if (!ozreadlines($file,$records,$error)) 
	{
		return false;
    }

	if (in_array($rec, $records))
	{
		return true;
	}
	return false;
}

function isSubscribedToService($userid, $servicename, &$error)
{
	global $regdir, $datadir, $servicesdir,$dirprefix;

	$usrdir = "$regdir/$userid";

	if (!ismd5($userid))
	{
		$error = "Invalid email hash for subscription";
		return false;
	}

	if (!ozfilenamesafe($servicename,$servicenamesafe,$error)) 
	{
		$error = "Invalid service name for subscription";
		return false;
	}
	$servicename = $servicenamesafe;

	if (!is_dir($usrdir))
	{
		$error = "Could not find user for subscription.";
		return false;
	}

	$srvdir = $dirprefix."/ozekiservices/".$servicename;
	if (!is_dir($srvdir))
	{
		$error = "Subscribed service does not exist.";
		return false;
	}

	$regfile = $usrdir."/subscriptions/subscriptions.txt";
	if (!file_exists($regfile))
	{
		$error = "Subscription file does not exist.";
		return false;
	}
	
	$rec = serviceSubscriptionRecord($servicename);
	if (!isinfilelist($regfile,$rec))
	{
		$error = "";
		return false;
	}

	$error = "";
	return true;
}

//**************************************************************
// Subscribe 
//**************************************************************

function subscribeService($userid, $servicename, &$error)
{
	global $servicedescription;

	$servicename = strtolower($servicename);

	$error = "";
	if (isSubscribedToService($userid, $servicename, $error)) return true;

	if (!is_array($servicedescription) && !includeDescription($servicename,$error)) 
	{
		$error = "Cannot subscribe to $servicename service. $error";
		return false;
	}

	if (is_array($servicedescription) && !array_key_exists($servicename,$servicedescription) && !includeDescription($servicename,$error))
	{
		$error = "Service descriptions for service '$servicename' could not be loaded.";
	}

	$ret = true;
	if (!subscribeServiceWithoutDeps($userid, $servicename, $error)) $ret = false;

	if (!is_array($servicedescription))
	{
		$error = "Service descriptions are not loaded.";
		return false;
	}

	if (
	   array_key_exists($servicename,$servicedescription) &&
	   is_array($servicedescription[$servicename]) &&
	   array_key_exists("linkedservices",$servicedescription[$servicename]) &&
	   is_array($servicedescription[$servicename]["linkedservices"]))
	{
        	foreach($servicedescription[$servicename]["linkedservices"] as $linkedservice)
        	{
            		if (!subscribeServiceWithoutDeps($userid, $linkedservice, $error)) $ret = false;
        	}
	}

	return $ret;
}

function subscribeServiceWithoutDeps($userid,$servicename,&$error)
{
	if (strlen($servicename)==0)
	{
		$error = "The service name cannot be empty for subscribe";
		return false;
	}

	if (!ismd5($userid))
	{
		$error = "Invalid user id for subscribe: $userid";
		return false;
	}

	if (!serviceExists($servicename))
	{
		$error = "Invalid service name for subscribe: $servicename";
		return false;
	}

	global $datadir;
	$usrdir = $datadir."/registrations/".$userid;
	if (!is_dir($usrdir))
	{
		$error = "Cannot install service $servicename. Could not find user for subscribe.";
		return false;
	}

	global $dirprefix;
	$srvdir = $dirprefix."/ozekiservices/".$servicename;
	if (!isInDir($dirprefix."/ozekiservices/",$srvdir,$error))
	{
		$error = "Cannot find service '$servicename' to  subscribe";
		reportHackAttempt();
		return false;
	}

	if (!is_dir($srvdir))
	{
		$error = "Cannot find service directory for '$servicename' to subscribe";
		return false;
	}

	if (isSubscribedToService($userid,$servicename,$error))
	{
		return true;
	}

	$subsdir = $usrdir."/subscriptions/";
	if (!ozmkdir($subsdir,$error))
	{
		$error = "Cannot create subscriptions dir for user. $error";
		return false;
	}

	$regfile = $usrdir."/subscriptions/subscriptions.txt";
	if (!is_file($regfile) || filesize($regfile) == 0)
	{
		$text = "<?php\r\n?>\r\n";
		if (!file_put_contents($regfile,$text))
		{
			$error = "Could not create subscriptions file";
			return false;
		}
	}

	$rec = serviceSubscriptionRecord($servicename);
	$subs = file_get_contents($regfile);
	$text = str_replace("?".">",$rec."\r\n?".">",$subs);
	if (!file_put_contents($regfile,$text))
	{
		$error = "Could not save subscriptions file";
		return false;
	}

	return true;
}


//**************************************************************
// Unsubscribe
//**************************************************************

function serviceSubscriptionRecord($servicename)
{
	return "include_once(\"\$servicesdir/$servicename/_include.php\");";
}

function unSubscribeService($serviceuserid, $servicename, &$error)
{
	global $servicedescription;

	$ret = true;
	if (!unSubscribeServiceWithoutDeps($serviceuserid, $servicename, $error)) $ret = false;
	
	if (
		oz_array_key_exists($servicename,$servicedescription) &&
		oz_array_key_exists("linkedservices",$servicedescription[$servicename]) &&
		is_array($servicedescription[$servicename]["linkedservices"]))
    {
        foreach($servicedescription[$servicename]["linkedservices"] as $linkedservice)
        {
            if (!unSubscribeServiceWithoutDeps($serviceuserid, $linkedservice, $error)) $ret = false;
        }
    }

	return $ret;
}


function unSubscribeServiceWithoutDeps($userid, $servicename, &$error)
{
	global $datadir, $debug;

	if (!ismd5($userid))
	{
		$error = "Invalid email hash";
		return false;
	}

	if (!serviceExists($servicename))
	{
		$error = "Invalid service name";
		return false;
	}

	$usrdir = $datadir."/registrations/".$userid;
	$regfile = $usrdir."/subscriptions/subscriptions.txt";
	if (!is_file($regfile))
	{
		$error = "Could not unsubscribe";
		if ($debug) $error .= ". Subscriptions file does not exist";
		return false;
	}

	if (!($file = fopen($regfile, "r"))) 
	{
		$error = "Could not unsubscribe";
		if ($debug) $error .= ". Could not open file";
		return false;
	}

	if (!($file_tmp = fopen("$regfile.tmp", "w"))) 
	{
		$error = "Could not unsubscribe";
		if ($debug) $error .= ". Could not open file";
		return false;
	}

	$rec = serviceSubscriptionRecord($servicename);
	while (($line = fgets($file)) !== false) 
	{
		if ($rec != rtrim($line)) {
			fwrite($file_tmp, $line);
		}
	}

	fclose($file);
	fclose($file_tmp);
	rename("$regfile.tmp", $regfile);

	return true;
}

function loadServiceDescriptions($userid,&$installed,&$error)
{
	if (!loadInstalledServices($userid,$installed,$error)) 
		return false;

    //************************************************************
    // Load sevice descriptions
    //************************************************************
    foreach ($installed as $servicename) 
    {
        includeDescription($servicename,$error);
    }
    usort($installed, "cmpSubscriptionOrder");

	return true;
}

//**************************************************************
// Is service visible
//**************************************************************
function isServiceVisible($servicename)
{
	global $servicedescription, $debug;

	if (array_key_exists("installable",$servicedescription[$servicename]) && 
		!$servicedescription[$servicename]["installable"]) return false;

	if (isDebug()) return true;
	if (isAdmin()) return true;

	if (isset($servicedescription[$servicename]["public"]) && 
	    $servicedescription[$servicename]["public"]) return true;

	return false;
}



//**************************************************************
// Service description template
//**************************************************************

function createServiceDescriptionFile($filename,$servicename)
{
	global $debug, $dirprefix;

	if (!($file = fopen($filename, "w"))) 
	{
		$error = "Error creating service subscription! Service description file cannot be opened for $servicename";
		echo $error;
		return;
	}

	$template = <<<TEMPLATE
	<?php
	\$servicename = "[SERVICENAME]";
	\$fullname = "[FULLNAME]";
	\$description = "This is the [FULLNAME] service";
	\$icon = "/ozekiservices/[SERVICENAME]/attachments/app.svg";
	\$order = 1000;
	
	//**************************************************
	// Service data
	//**************************************************
	\$servicedescription[\$servicename]["name"] = \$servicename;
	\$servicedescription[\$servicename]["fullname"] = \$fullname;
	\$servicedescription[\$servicename]["description"] = \$description;
	\$servicedescription[\$servicename]["icon"] = \$icon;
	\$servicedescription[\$servicename]["public"] = false;
	\$servicedescription[\$servicename]["quicklink"] = false;
	\$servicedescription[\$servicename]["navbarlink"] = true;
	\$servicedescription[\$servicename]["navbaradmin"] = true;
	\$servicedescription[\$servicename]["serviceprovider"] = false;
	\$servicedescription[\$servicename]["servicemanager"] = false;
	\$servicedescription[\$servicename]["serviceowner"] = false;
	\$servicedescription[\$servicename]["home"] = "page_[SERVICENAME]_home";
	\$servicedescription[\$servicename]["order"] = \$order;
	\$servicedescription[\$servicename]["canbeinstalled"] = true;
	?>
TEMPLATE;
	
	$fullname = ucfirst($servicename);
	$template = str_replace("[SERVICENAME]", $servicename, $template);
	$template = str_replace("[FULLNAME]", $fullname, $template);

	fwrite($file, $template);
	fclose($file);
}

function includeDescription($servicename,&$error)
{
	global $dirprefix,$servicedescription;

	if (!serviceExists($servicename))
	{
		$error = "Invalid service name for description include";
		return false;
	}

	$dfile = $dirprefix."/ozekiservices/$servicename/description.php";
	if (!file_exists("$dfile")) 
	{
		createServiceDescriptionFile($dfile,$servicename);
		include_once($dfile);
		return true;
	}

	global $fullname,$description,$icon,$servicedescription;
	$home = "page_".$servicename."_home";
	global $$home;

	include_once($dfile);
	return true;
}

function includeDescriptions()
{
	global $dirprefix, $debug, $servicedescription, $descriptionsincluded;
	if ($descriptionsincluded) return;
	$descriptionsincluded = true;

	$path = $dirprefix."/ozekiservices";
	$files = glob($path.'/*');
	foreach ($files as $file) 
	{
		$servicename = basename($file);
		includeDescription($servicename,$error);
	}
}

//**************************************************************
// Load system services
//**************************************************************

function loadSystemServices(&$systemservicelist, &$error)
{
	global $configdir, $debug, $servicedescription;

	$error = null;
	$systemservicelist = [];

	$servicefile = "$configdir/services.php";
	if (!file_exists($servicefile)) 
	{
		return false;
    }

	if (!($file = fopen($servicefile, "r"))) 
	{
		$error = "Error listing system services!<br>";
		if ($debug) $error .= "Error opening the file: $servicefile";
		return false;
	}

	while (($line = fgets($file)) !== false) 
	{
		if (ozstartswith($line,"#")) continue;
		if (ozstartswith($line,"//")) continue;
		$line = htmlspecialchars($line);
		if (!strpos($line, "\$servicesdir")) continue;
		
		$tmp = substr($line, strpos($line, "\$servicesdir/") + strlen("\$servicesdir/"));
		$servicename = strtok($tmp, '/');
		$systemservicelist[$servicename] = $servicename;
	}

	return true;
}

function cmpSubscriptionOrder($servicename1, $servicename2)
{
	global $servicedescription;

	if (!array_key_exists("order",$servicedescription[$servicename1])) $servicedescription[$servicename1]["order"] = 0;
	if (!array_key_exists("order",$servicedescription[$servicename2])) $servicedescription[$servicename2]["order"] = 0;

	if ($servicedescription[$servicename1]["order"] == $servicedescription[$servicename2]["order"]) 
	{
		$name1 = array_key_exists("name",$servicedescription[$servicename1])?$servicedescription[$servicename1]["name"]:"";
		$name2 = array_key_exists("name",$servicedescription[$servicename2])?$servicedescription[$servicename2]["name"]:"";
		return strcmp($name1, $name2);
	}
	
       return $servicedescription[$servicename1]["order"] - $servicedescription[$servicename2]["order"];
}

//**************************************************************
// Quick install form
//**************************************************************
function printQuickInstallForm()
{
	global $owpn,$myuserid;

$frm =<<<QUICKINSTALLFORM
	<div class="float-end">
	<FORM action="index.php" method="GET">
	<INPUT type="hidden" name="owpn" value="$owpn">
	<INPUT type="hidden" name="myserviceaction" value="installozekiservice">
	<INPUT type="hidden" name="myserviceuser" value="$myuserid">
	<div class="float-start" style="width:200px">
		<div class="float-start"><INPUT type="text" name="myservicename" value="" placeholder="Service" style="width:120px"></div>
		<div class="float-start"><INPUT type="submit" class="btn btn-primary btn-sm ms-2" value="Install"></div>
	</div>
	</FORM>
	</div>
QUICKINSTALLFORM;

return $frm;
}

//**************************************************************
// Print service line
//**************************************************************
function printVersionSelectorLink($servicename,$userid)
{
	global $servicedescription;
	if (!isset($servicedescription[$servicename]["versions"]["published"]) ||
	    !is_array($servicedescription[$servicename]["versions"]["published"])) return "";

	$style = "style='font-size:0.8rem'";
    $link ="<a href='index.php?owpn=page_subscriptions_changeversion&myservicename=$servicename&myserviceuser=$userid'  $style>Change version</a>";
	return $link;
}

function printServiceLine($servicename, $userid, $label)
{
	global $owpn,$dirprefix,$servicedescription,$debug;

	if (!array_key_exists($servicename,$servicedescription))
	{
		return "Could not find service description for service: '$servicename'";
	}

	if (!array_key_exists('fullname',$servicedescription[$servicename]))
	{
		return "Service description is incomplete for service: '$servicename'. This service is not available in your system.";
	}

	$fullname = $servicedescription[$servicename]["fullname"];
	$icon = $servicedescription[$servicename]["icon"];
	$description = $servicedescription[$servicename]["description"];
	$home = $servicedescription[$servicename]["home"];
	$order = $servicedescription[$servicename]["order"];

	//Open button
	$openbutton = "<TD>";
	$openbutton .= "<a href=\"index.php?owpn=$home\"><div class=\"btn btn-success btn-sm\">Open</div></a>";
	$openbutton .= "</TD>";
	
	if ($label !== "Uninstall") 
	{
		$openbutton = "";
	}

	//Install link
	$links=[];
	$installbutton = "";
	if (!array_key_exists("system",$servicedescription[$servicename]) || 
	    !$servicedescription[$servicename]["system"])
	{
		$buttonclass = ($label == "Uninstall" ? "btn-danger" : "btn-primary");
		
		if ($label=="Uninstall") 
		{
			$buttonalert = "onclick=\"return confirm('Are you sure you wish to uninstall this service?')\"";
			$style = "style='font-size:0.8rem'";
			$uninstalllink = "<a href='index.php?owpn=$owpn&myserviceaction=uninstallozekiservice&myservicename=$servicename&myserviceuser=$userid' $buttonalert $style>Click here to uninstall</a>";
			$links[]=$uninstalllink;
		}
		if ($label=="Install") {
			$installlink = '<div class="btn btn-primary btn-sm">'.$label.'</div>';
			$installbutton  ="<td>";
			$installbutton .= "<a href='index.php?owpn=$owpn&myserviceaction=installozekiservice&myservicename=$servicename&myserviceuser=$userid'>$installlink</a>";
			$installbutton .= "</td>";
		}
	}

	if($label=="Uninstall")
	{
		$versionlink=printVersionSelectorLink($servicename,$userid);
		if($versionlink)$links[]=$versionlink;
	}

	//Icon
	$iconpath = $dirprefix.$icon;
	if (!file_exists($iconpath))
	{
		$icon = "/ozekiservices/subscriptions/attachments/appdefault.svg";
	}

	$linksjoined=implode(" | ",$links);

$line =<<<LINEEND
	<div class="row border-bottom m-0" >

		<div class="d-flex align-items-center justify-content-begin col-8 col-sm-8 px-0">
			<table>
				<tr><td>
					<svg width="60" height="60" style="padding: 0;">       
					<image xlink:href="$icon" x="50%" y="50%" transform="translate(-15,-15)" width="30" height="30"/>    
					</svg>
				</td><td>
					<div style="text-align: left;">
					<h5 class="mb-0">$fullname</h5>
					<span style="font-size:0.8rem">$description</span>
					<div> $linksjoined </div>
					</div>
				</td></tr>
			</table>
		</div>

		<div class="d-flex align-items-center justify-content-end col-3 col-sm-3 ms-3 px-0" >
			<table>
			<tr>
			$openbutton
			<td>&nbsp;</td>
			$installbutton		
			</tr>
			</table>
		</div>
	</div>
LINEEND;

	return $line;
}

//**************************************************************
// Load installed user services
//**************************************************************

function loadInstalledServices($userid, &$installedservicelist, &$error)
{
	global $datadir,$dirprefix,$debug,$servicedescription,$servicesdir;

	if (!ismd5($userid))
	{
		$error = "Cannot load services. Invalid user id: $userid";
		return false;
	}

	$usrdir = $datadir."/registrations/".$userid;
	if (!is_dir($usrdir))
	{
		$error = "Cannot load services. User not found: $userid";
		return false;
	}

	$installedservicelist = [];
	$subscriptionsfile = "$usrdir/subscriptions/subscriptions.txt";
	if (!is_dir("$usrdir/subscriptions") && !ozmkdir("$usrdir/subscriptions", $error)) 
	{
		$error = "Could not install services. Error creating directory: $usrdir/subscriptions";
		return false;
    }

	$text = "<"."?php\r\n?".">\r\n";
	if (!is_file($subscriptionsfile) && !file_put_contents($subscriptionsfile, $text))
	{
		$error = "Could not install service";
		if ($debug) $error .= "Error creating file: $subscriptionsfile";
		return false;
	}

	if (!($file = fopen($subscriptionsfile, "r"))) 
	{
		$error = "Error listing installed subscriptions! Error opening the file: $usrdir/subscriptions/subscriptions.txt";
		return false;
	}

	while (($line = fgets($file)) !== false) 
	{
		if (preg_match('/include_once.["\']([^"\']*)["\']/',$line,$matches))
		{
        	$filetoinclude = $matches[1]; 
            $f = str_replace('$servicesdir',$servicesdir,$filetoinclude);
			if (!file_exists($f)) continue;
		}

		$line = htmlspecialchars($line);
		$line = str_replace("\$servicesdir", "$servicesdir", $line);
		if (!strpos($line, "$dirprefix/ozekiservices/")) continue;
		
		$tmp = substr($line, strpos($line, "$dirprefix/ozekiservices/") + strlen("$dirprefix/ozekiservices/"));
		$servicename = strtok($tmp, '/');
		$installedservicelist[$servicename] = $servicename;
		if (!isset($servicedescription[$servicename]["order"])) $servicedescription[$servicename]["order"] = 1000;
	}

	$systemservicelist = array();
	if (!loadSystemServices($systemservicelist, $error))
	{
		return false;
	}

	foreach ($systemservicelist as $service)
	{
		$installedservicelist[$service] = $service;
	}

	foreach ($installedservicelist as $service)
	{
		if (in_array($service, $systemservicelist)) {
			$servicedescription[$service]["system"] = true;
		}
	}

	usort($installedservicelist, "cmpSubscriptionOrder");

	return true;
}

function isInstalllinkVisible($servicename)
{
	global $servicedescription;
	$sd = $servicedescription[$servicename];
	if (!array_key_exists("installlink",$sd)) 
	{
		return true;
	}
	if ($sd["installlink"]) return true;

	return false;
}

function isInstallable($servicename)
{
	global $servicedescription;
	$sd = $servicedescription[$servicename];
	if (!array_key_exists("canbeinstalled",$sd)) 
	{
		return true;
	}
	if ($sd["canbeinstalled"]) return true;

	return false;
}


function printInstalledServices($userid, &$error, $extraaction = "none")
{
	global $servicedescription;

	if (!loadInstalledServices($userid, $installed, $error)) return;

	$content = "";
	foreach ($installed as $servicename) 
	{
		if (!isServiceVisible($servicename)) continue;
		if (!isInstalllinkVisible($servicename)) continue;
		if (!isInstallable($servicename)) continue;
		$content .= printServiceLine($servicename, $userid, "Uninstall", $extraaction);
	}
	
	if ($content=="") $content = "<h4>You don't have any subscriptions.</h4>";

	$card = card("Installed",printQuickInstallForm(),"#c9daff");
	$card .= $content;
	$card .= cardend();

	$cardd =<<<CARDEND
	<div class="card mb-3" style="background-color: #c9daff;">
		<div class="card-header">
			<h3 class="m-0 float-sm-start">Installed services</h4>
		</div>
		<div class="card-body bg-light">
			<div class="table text-center mobiletextleft" frame="box">
			$content
	    	</div>
		</div>
    </div>
CARDEND;

	return $card;
}

//**************************************************************
// Load not installed user services
//**************************************************************

function loadNotInstalledServices($userid, &$notinstalledservicelist,&$error)
{
	global $datadir,$dirprefix,$debug,$servicedescription,$servicesdir;

	if (!ismd5($userid))
	{
		$error = "Cannot load not installed services. Invalid userid.";
		return false;
	}

	$usrdir = $datadir."/registrations/".$userid;
	if (!is_dir($usrdir))
	{
		$error = "Cannot load not installed services. User not found: $userid";
		return false;
	}

	$subscriptionsfile = "$usrdir/subscriptions/subscriptions.txt";
	if (!is_dir("$usrdir/subscriptions") && !ozmkdir("$usrdir/subscriptions", $error)) 
	{
		$error = "Could not install service. Error creating directory: $usrdir/subscriptions";
		return false;
    }

	$text = "<"."?php\r\n?".">\r\n";
	if (!is_file($subscriptionsfile) && !file_put_contents($subscriptionsfile, $text))
	{
		$error = "Could not install service";
		if ($debug) $error .= "Error creating file: $subscriptionsfile";
		return false;
	}

	if (!($file = fopen($subscriptionsfile, "r"))) 
	{
		$error = "Error listing not installed services!";
		return false;
	}

	$names = array();
	foreach ($servicedescription as $service) 
	{
		if (!array_key_exists("name",$service))
		{
			if ($debug)
			{
				echo "Service name missing";
				var_dump($service);
				exit;
			}
			continue;
		}
		$servicename = $service["name"];
 		$names[] = $servicename;
		$details[$servicename] = array("icon" => $service["icon"], "description" => $service["description"]);
	}

	$installedservicelist = array();
	$notinstalledservicelist = [];
	while (($line = fgets($file)) !== false) 
	{
		$line = htmlspecialchars($line);
		$line = str_replace("\$servicesdir", "$servicesdir", $line);
		if (!strpos($line, "$dirprefix/ozekiservices/")) continue;
		
		$tmp = substr($line, strpos($line, "$dirprefix/ozekiservices/") + strlen("$dirprefix/ozekiservices/"));
		$servicename = strtok($tmp, '/');
		$installedservicelist[] = $servicename;
	}

	$systemservicelist = array();
	if (!loadSystemServices($systemservicelist, $error))
	{
		return false;
	}

	foreach ($names as $name) 
	{
		if (!in_array($name, $installedservicelist) && !in_array($name, $systemservicelist)) 
		{
			array_push($notinstalledservicelist, $name);
			if (!isset($servicedescription[$name]["order"])) $servicedescription[$name]["order"] = 1000;
		}
	}

	usort($notinstalledservicelist, "cmpSubscriptionOrder");

	return true;
}

function printNotInstalledServices($userid, &$error)
{
	global $servicedescription;

	if (!loadNotInstalledServices($userid, $notinstalled,$error)) return;
	
	$content = "";
	foreach ($notinstalled as $servicename) 
	{
		if (!isServiceVisible($servicename)) continue;
		if (!isInstalllinkVisible($servicename)) continue;
		if (!isInstallable($servicename)) continue;
		$content .= printServiceLine($servicename, $userid, "Install");
	}

	if ($content=="") return "";
	//$content = "<h4>You are subscribed to all available services.</h4>";

	$card =<<<CARDEND
	<div class="card mb-3" style="background-color: #e3e7e0;">
		<div class="card-header p-2">
			<h3 class="m-0 float-sm-start">Services you might like</h4>
		</div>
		<div class="card-body bg-light p-2">
			
			$content
	    	
		</div>
    </div>
CARDEND;

	return $card;
}

function comboServices($userhash, $selectedservicename = null, $public = true, $inputname = "combo-services", $services = null)
{
	global $servicedescription;

	includeDescriptions();
	$allservices = array();
	if (!is_array($services)) {
		loadInstalledServices($userhash, $services, $error);
		foreach ($services as $service) {
			$allservices[$service] = $service;
		}
		loadNotInstalledServices($userhash, $services, $error);
		foreach ($services as $service) {
			$allservices[$service] = $service;
		}
	}

	if ($public) {
		foreach ($allservices as $service) {
			if (!isServiceVisible($service)) {
				unset($allservices[$service]);
			}
		}
	}

	asort($allservices);

	$combo = "<SELECT name='$inputname' id='$inputname' class='me-2 form-select'>";
	$combo .= "<OPTION value='default'";
	if ($selectedservicename == null) {
		$combo .= " SELECTED";
	}
	$combo .= ">-- Select service --</OPTION>";
	
	foreach ($allservices as $service)
	{
		$selected = ($service == $selectedservicename) ? "SELECTED" : "";
		$key = $servicedescription[$service]["name"];
		$displayed = $servicedescription[$service]["fullname"];
		$combo .= "<OPTION value='$key' $selected>$displayed</OPTION>";
	}
	$combo .= "</SELECT>";

	return $combo;
}

function comboServicesInstalled($userhash, $inputname = "combo-installed-services", $selectedservicename = null, $services = null)
{
	global $servicedescription;

	includeDescriptions();
	if (!is_array($services)) loadInstalledServices($userhash, $services, $error);

	asort($services);

	$combo = "<SELECT name='$inputname' id='$inputname' class='me-2 form-select'>";
	$combo .= "<OPTION value='default'"; 
	if ($selectedservicename == null) {
		$combo .= " SELECTED";
	}
	$combo .= ">-- Select service --</OPTION>";
	
	foreach ($services as $service)
	{
		$selected = ($service == $selectedservicename) ? "SELECTED" : "";
		$key = $servicedescription[$service]["name"];
		$displayed = $servicedescription[$service]["fullname"];
		$combo .= "<OPTION value='$key' $selected>$displayed</OPTION>";
	}
	$combo .= "</SELECT>";

	return $combo;
}

function comboServicesNotInstalled($userhash, $inputname = "combo-uninstalled-services", $selectedservicename = null, $services = null)
{
	global $servicedescription;

	includeDescriptions();
	if (!is_array($services)) {
		if (!loadNotInstalledServices($userhash, $services, $error))
		{
			echo $error;
		}
	}
	if (!is_array($services)) $services	= [];

	asort($services);

	$combo = "<SELECT name='$inputname' id='$inputname' class='me-2 form-select'>";
	$combo .= "<OPTION value='default'"; 
	if ($selectedservicename == null) {
		$combo .= " SELECTED";
	}
	$combo .= ">-- Select service --</OPTION>";
	
	foreach ($services as $service)
	{
		$selected = ($service == $selectedservicename) ? "SELECTED" : "";
		$key = $servicedescription[$service]["name"];
		$displayed = $servicedescription[$service]["fullname"];
		$combo .= "<OPTION value='$key' $selected>$displayed</OPTION>";
	}
	$combo .= "</SELECT>";

	return $combo;
}

?>