<?php


function quickInstall()
{
    //global $page_subscriptions_subscriptions;
   
    $card =<<<QIEND
    <div class="m-0 ">
    <div class="m-0 h-md-100 ecommerce-card-min-width text-end">
        <a href='index.php?owpn=page_subscriptions_subscriptions' class="m-0" >
        <button class="btn btn-primary" name="random">Install services...</button>
        </a>
    </div>
    </div>
QIEND;

    return $card;
}

//**********************************************
// Is quicklink visible
//**********************************************

function isQuickLinkVisible($servicename)
{
    global $servicedescription;
    if (!isset($servicedescription[$servicename]["quicklink"])) return false;
    if (isset($servicedescription[$servicename]["quicklink_visible"])) return $servicedescription[$servicename]["quicklink_visible"];
    return $servicedescription[$servicename]["quicklink"];
}

//**********************************************
// Is service provider
//**********************************************

function isServiceProvider($servicename)
{
    global $servicedescription;
    if (!array_key_exists("serviceprovider",$servicedescription[$servicename])) return false;
    return $servicedescription[$servicename]["serviceprovider"];
}

//**********************************************
// Is service manager
//**********************************************

function isServiceManager($servicename)
{
    global $servicedescription;
    if (!array_key_exists("servicemanager",$servicedescription[$servicename])) return false;
    return $servicedescription[$servicename]["servicemanager"];
}

//**********************************************
// Is service owner
//**********************************************

function isServiceOwner($servicename)
{
    global $servicedescription;
    if (!array_key_exists("serviceowner",$servicedescription[$servicename])) return false;
    return $servicedescription[$servicename]["serviceowner"];
}

//**********************************************
// Print service open card
//**********************************************

function printServiceIconCard($servicename)
{
    global $servicedescription,$dirprefix,$debug;

    $fullname = $servicedescription[$servicename]["fullname"];
    $desc = $servicedescription[$servicename]["description"];
    $home = $servicedescription[$servicename]["home"];
    $icon = $servicedescription[$servicename]["icon"];
    $order = $servicedescription[$servicename]["order"];
    if (array_key_exists("quicklink_label",$servicedescription[$servicename]))
    {
        $fullname = $servicedescription[$servicename]["quicklink_label"];
    }

    $notificon = "";
    if (array_key_exists("quicklink_notifcount",$servicedescription[$servicename]))
    {
        $cnt = $servicedescription[$servicename]["quicklink_notifcount"]();
        if ($cnt>0) {
           $notificon .=  "<span style='position: relative; right: -3rem;top: -5.5rem; height: 1rem; width: 1rem; font-size: .67rem; color: white; background:red; font-weight: 700;  border: red 2px solid; border-radius: 10px;'>$cnt</span>";
        }
    }

    $iconpath = $dirprefix.$icon;
	if (!file_exists($iconpath))
	{
		$icon = "/ozekiservices/subscriptions/attachments/appdefault.svg";
	}

$card =<<<CARDEND
    <div class="float-start m-2" >
       <div class="text-center">
        <a href='index.php?owpn=$home'>
        <span><img src="$icon" id="" alt="onboarding" border=0 height="60" /></span>
        <br>
        <h5 style="display: inline;">$fullname</h5>
        </a>
       </div>
       $notificon
    </div>    
CARDEND;

    return $card;
}

//**********************************************
// Display
//**********************************************
function printDashCardServiceIcons($userid,$title,$serviceprovider)
{

    $quickInstallButton = ($serviceprovider) ? "" : quickInstall();

    if (!loadInstalledServices($userid,$installed,$error)) return "";
    foreach ($installed as $servicename) 
    {
        includeDescription($servicename,$error);
    }
    usort($installed, "cmpSubscriptionOrder");

    $icons = "";
    foreach ($installed as $servicename) 
    {
        if (!isQuickLinkVisible($servicename)) continue;
		if ($serviceprovider != isServiceProvider($servicename)) continue;
        $icons .= printServiceIconCard($servicename);
    }

$iconCard = <<<ICONCARDEND
    <div class="card mb-3" style="background-color: #c9daff;">
        <div class="card-header">
            <h3 class="m-0 float-sm-start">$title</h3>
            $quickInstallButton
        </div>
        <div class="card-body bg-light pt-3">
            <div class="g-3">
            $icons
            </div>
        </div>
    </div>
ICONCARDEND;
    
    return $iconCard;
}



?>
