<?php
//***********************************************
// Reset user password
//***********************************************
$resultVisible = false;
$errorCurrentPassword = "";
$errorPassword = "";
$userpassword = ozrndstr(8,true);

$passreadonly = isPasswordReadonly($userid,$mypassword);

$myaction = (isset($_POST['myaction'])) ? $_POST['myaction'] : "";
if ($myaction=="changepassword")
{
	if (!$passreadonly) 
	{
		$currentpassword = $_POST["mycurrentpassword"];
	}
	$password1 = $_POST["mypassword1"];
	$password2 = $_POST["mypassword2"];
	
	$datavalid=true;
	
	if ($datavalid)
	{
		if (!importRsaPublicKeyFromPEM($adminpublickeypem, $adminpublickey,$error))
		{
			$errorPassword = $error;
			$datavalid=false;
		}
	}

	if (!$passreadonly) 
	{
		$pwhash = sha512($currentpassword);
		$pemprivatefile1 = $userdir."/privatekey_".$pwhash.".txt";
		if (!file_exists($pemprivatefile1))
		{
			$errorCurrentPassword = "Invalid current password";
			$datavalid = false;
		}
	}

	if ($datavalid && !isvalidpasswords($password1,$password2,$error)) 
	{
		$errorPassword = $error;
		$datavalid = false;
	}

	if ($datavalid && !is_dir($userdir)) {
		$errorPassword  = "Could not find this user";
		$datavalid = false;
	} 

	if ($datavalid)
	{
		//Create new password for user
		$datavalid = createPasswordForUser($myuserid,$myprivatekey,$password1,!$passreadonly,$errorPassword);
	}

	if ($datavalid)
	{
		$resultVisible = true;
		echo cardbegin();
		echo displaySuccess("Password updated successfully",null,"Go to dashboard",$page_dashboard);
		echo cardend();
		return;
	}
}

//***********************************************
// display password form
//***********************************************

$errorCPwd = (isset($errorCurrentPassword)) ? '<span style="color:red">'.$errorCurrentPassword.'</span>' : "";
$errorPwd = (isset($errorPassword)) ? '<span style="color:red">'.$errorPassword.'</span>' : "";

if ($passreadonly) {
	$instruction = "Please create a password to make your account more secure";
	$currentPwInput = "";
} else {
	$instruction = "Please enter your current password and provide your new password in the form below";
	$currentPwInput = <<<CPWFORMEND
	<div class="mb-3">
		<label class="form-label" for="toname">Current password</label>
		<input class="form-control" name="mycurrentpassword" type="password" autocomplete="off" style="background-color: #e0ffe0" 
		readonly onfocus="this.removeAttribute('readonly');" value="" required/>
		$errorCPwd
	</div>
CPWFORMEND;
}


$pwform = <<<PWFORMEND
	<div style='max-width:400px'>
	<p>$instruction</p>
	<form enctype="multipart/form-data" action="index.php" method="post" novalidate>
		<input type="hidden" name="owpn" value="$owpn">
		<input type="hidden" name="myaction" value="changepassword">
		$currentPwInput
		<div class="mb-3">
			<label class="form-label" for="subject">New password</label>
			<input class="form-control" name="mypassword1" type="password"  readonly onfocus="this.removeAttribute('readonly');" required/>
		</div>
		<div class="mb-3">
			<label class="form-label" for="subject">Repeat password</label>
			<input class="form-control" name="mypassword2" type="password"  readonly onfocus="this.removeAttribute('readonly');" required/>
			$errorPwd
		</div>
		<div class="mb-3">
			<button class="btn btn-primary" type="submit" name="messagecreate-submit">Change my password</button>
		</div>
	</form>
	</div>
PWFORMEND;

echo card("Change password");
echo $pwform;
echo cardend();
?>