<?php

if (isDecisionMaker() || isStaff() || isExStaff()) 
{
    echo displayInfoBar("Privileged accounts cannot be deleted.");
    return;
}

//*************************************************************
// Delete account
//*************************************************************
global $delconfirmation;
loadReqParams("delconfirmation");
if ($delconfirmation=='delete')
{
    include_once("$dirprefix/ozeki/sys/authentication/accountdelete.php");
    echo displayInfoBar("Your account has been deleted successfully.");
    delete_account($myuserid);
    logoutFromSession();
}

//*************************************************************
// Display form
//*************************************************************

$delurl = "index.php?owpn=page_profile_deleteaccount";
$areyousure = areyousure("Are you sure you would like to delete your account?");
$delcontext = "";
if (isDebug()) $delcontext = 'delete';

echo card("Administration");
echo <<<WARNEND

<div style='max-width:600px'>
<h1>Delete account request</h1>


On this form you may delete your Ozeki Account. Note, that if you delete your account,
<span style='color: red; font-weight: bold;'> all your data will be lost</span>. We are
sorry to see you go, but we wish you all the best.

<div class='mt-3'>
<form action='index.php' method='post'>
<input type='hidden' name='owpn' value='page_profile_deleteaccount'>
To delete your account, please type the word <b>'delete'</b> into the field below and
click on the red 'Delete my account' button.
<div class='mt-3'><b>Confirmation:</b></div>
<div><input type='text' name='delconfirmation' class='form-control' style='max-width:250px' value='$delcontext'></div>
<div><input type=submit class='btn btn-danger mt-3' style='color:white' value='Delete my account'></div>
</form>
</div>

</div>

WARNEND;
echo cardend();

?>