<?php
//*************************************************************
// Share data
//*************************************************************

global $shareconfirmation,$adminuserid,$adminpublickey,$myprivatekey;
loadReqParams("shareconfirmation");
if ($shareconfirmation=='share')
{
    echo displayInfoBar("Your account RSA key has been shared with admin.");

    //Keys shared for admin password reset
    $prstoadminfile =  "$userdir/sharedto/$adminuserid"."_rsa.txt";
    if (!exportRsaPrivateKeyAsPEM($myprivatekey,null,$pemprivate,$error))
    {
        echo displayError("Cannot share data",$error);
        return;
    }
    $prstoadmin = encryptTextRSAAES($adminpublickey,$pemprivate);
    if (!file_put_contents($prstoadminfile,$prstoadmin))
    {
        $error = "Cannot write admin prs file ".error_get_last()["message"];
        echo displayError("Cannot share data",$error);
        return;
    }
    echo displaySuccess("Data sharing","Data shared successfully with Admin");
    return;
}

//*************************************************************
// Display form
//*************************************************************

$delurl = "index.php?owpn=page_profile_deleteaccount";
$areyousure = areyousure("Are you sure you would like to delete your account?");
$sharecontext = "";
if (isDebug()) $sharecontext = 'share';

echo card("Administration");
echo <<<WARNEND

<div style='max-width:600px'>
<h1>Share account data</h1>

On this form you may share your data with the admin user. Note, that if you share your data,
<span style='color: red; font-weight: bold;'> the admin will have access to all your data</span>.
This is only required if you want the administrator to investigate an issue related 
to a software problem. 

<div class='mt-3'>
<form action='index.php' method='post'>
<input type='hidden' name='owpn' value='page_profile_allowadmin'>
To share your data, please type the word <b>'share'</b> into the field below and
click on the red 'Share my account data' button.
<div class='mt-3'><b>Confirmation:</b></div>
<div><input type='text' name='shareconfirmation' class='form-control' style='max-width:250px' value='$sharecontext'></div>
<div><input type=submit class='btn btn-danger mt-3' style='color:white' value='Share my data'></div>
</form>
</div>

</div>

WARNEND;
echo cardend();

?>