<?php
//**************************************
// On user created hook function
//**************************************
function profileUserUpdated($userid,$userdetails,&$error,$aeskey=null)
{
    global $dirprefix;
    include_once("$dirprefix/ozekiservices/profile/common.php");

    if (!loadProfile($userid,$myprofile,$error,$aeskey))
    {
        $error = "Cannot load profile in update hook. $error";
        return false;
    }

    $myprofile["Personal"]["Name"] = $userdetails["fullname"];
    $myprofile["Contact"]["Email"] = $userdetails["email"];
    $myprofile["Contact"]["Mobile"] = $userdetails["mobile"];
    
    if (!saveProfile($userid,$myprofile,$error,$aeskey))
    {
        $error = "Cannot save profile in update hook. $error";
        return false;
    }

    return true;
}

function profileUserCreated($userid,$userdetails,&$error,$rsakey,$aeskey)
{
    global $dirprefix;
    include_once("$dirprefix/ozekiservices/profile/common.php");

    if (existsProfile($userid))
        return true;

    if (!createProfileWithDetails($userid,$userdetails,$myprofile,$error))
    {
        $error = "Cannot create profile in create hook. $error";
        return false;
    }

    if (!saveProfile($userid,$myprofile,$error,$aeskey))
    {
        $error = "Cannot save profile in create hook. $error";
        return false;
    }

    return true;
}

//**************************************
// Subscribe for events
//**************************************
include_once("$sysdir/events/_include.php");
SubscribeOnUserUpdated("profileUserUpdated");
SubscribeOnUserCreated("profileUserCreated");
?>