<?php
//**************************************************************
// Validators
//**************************************************************

function isvalidfacebook($myfacebook, &$error) : bool
{
    if (strlen($myfacebook)==0) return true;
    
    if (!filter_var($myfacebook, FILTER_VALIDATE_URL)) 
    {
        $error = "This is not a valid facebook url";
        return false;
    }

    if (!ozstartswith(strtolower($myfacebook),"https://www.facebook.com") &&
        !ozstartswith(strtolower($myfacebook),"https://facebook.com") &&
        !ozstartswith(strtolower($myfacebook),"http://www.facebook.com") &&
        !ozstartswith(strtolower($myfacebook),"http://facebook.com")
        )
    {
        $error = "This is not a facebook url";
        return false;
    }
    return true;
}

function isvalidtwitter($mytwitter, &$error) : bool
{
    if (strlen($mytwitter)==0) return true;

    if (!filter_var($mytwitter, FILTER_VALIDATE_URL))
    {
        $error = "This is not a valid twitter url";
        return false;
    }

    if (!ozstartswith(strtolower($mytwitter),"https://www.twitter.com") &&
        !ozstartswith(strtolower($mytwitter),"https://twitter.com")
        )
    {
        $error = "This is not a twitter url";
        return false;
    }
    return true;
}

function isvalidlinkedin($mylinkedin, &$error) : bool
{
    if (strlen($mylinkedin)==0) return true;

    if (!filter_var($mylinkedin, FILTER_VALIDATE_URL))
    {
        $error = "This is not a valid linkedin url";
        return false;
    }

    if (!ozstartswith(strtolower($mylinkedin),"https://www.linkedin.com/in") &&
        ozstartswith(strtolower($mylinkedin),"https://linkedin.com/in")
        )
    {
        $error = "This is not a linkedin url";
        return false;
    }
    return true;
}

function isvalidgithub($mygithub, &$error) : bool
{
    if (strlen($mygithub)==0) return true;

    if (!filter_var($mygithub, FILTER_VALIDATE_URL))
    {
        $error = "This is not a valid github url";
        return false;
    }

    if (!ozstartswith(strtolower($mygithub),"https://www.github.com") &&
        !ozstartswith(strtolower($mygithub),"https://github.com") 
        )
    {
        $error = "This is not a github url";
        return false;
    }
    return true;
}

function isvalidinstagram($myinstagram, &$error) : bool
{
    if (strlen($myinstagram)==0) return true;
    
    if (!filter_var($myinstagram, FILTER_VALIDATE_URL)) 
    {
        $error = "This is not a valid Instagram url";
        return false;
    }

    if (!ozstartswith(strtolower($myinstagram),"https://www.instagram.com") &&
        ozstartswith(strtolower($myinstagram),"https://instagram.com")
        )
    {
        $error = "This is not an Instagram url";
        return false;
    }
    return true;
}

function isvalidyoutube($myyoutube, &$error) : bool
{
    if (strlen($myyoutube)==0) return true;
    
    if (!filter_var($myyoutube, FILTER_VALIDATE_URL)) 
    {
        $error = "This is not a valid Youtube url";
        return false;
    }

    if (!ozstartswith(strtolower($myyoutube),"https://www.youtube.com") &&
        ozstartswith(strtolower($myyoutube),"https://youtube.com")
        )
    {
        $error = "This is not a Youtube url";
        return false;
    }
    return true;
}

function isvalidsnapchat($mysnapchat, &$error) : bool
{
    if (strlen($mysnapchat)==0) return true;

    if (!filter_var($mysnapchat, FILTER_VALIDATE_URL))
    {
        $error = "This is not a valid snapchat url";
        return false;
    }

    if (!ozstartswith(strtolower($mysnapchat),"https://www.snapchat.com/") &&
        ozstartswith(strtolower($mysnapchat),"https://snapchat.com/")
        )
    {
        $error = "This is not a snapchat url";
        return false;
    }
    return true;
}

//**************************************************************
// Edit social
//**************************************************************
global $useraeskey,$returnpage,$userid,$myaction;
loadOptionalRequestParameters("useraeskey","returnpage","userid");
if (isEmpty($returnpage)) $returnpage = $page_profile_myprofile;

loadOrCreateProfile($userid,$myprofile,$error,$useraeskey);

$formVisible = true;
$resultVisible = false;
$facebookError = "";
$twitterError = "";
$linkedinError = "";
$githubError = "";
$whatsapperror = "";
$vibererror = "";
$snapchaterror = "";
$instagramError = "";
$skypeError = "";
$youtubeError = "";

loadMyAction();
if ($myaction=="updatesocial")
{
	$myfacebook = $_POST["myfacebook"];
	$mytwitter = $_POST["mytwitter"];
	$mylinkedin = $_POST["mylinkedin"];
	$mygithub = $_POST["mygithub"];
	$myskype = $_POST["myskype"];
	$myinstagram = $_POST["myinstagram"];
    $myyoutube = $_POST["myyoutube"];
	$mywhatsapp = $_POST["mywhatsapp"];
	$myviber = $_POST["myviber"];
	$mysnapchat = $_POST["mysnapchat"];
	
	$datavalid=true;
	if ($datavalid && !isvalidfacebook($myfacebook, $error))
	{
		$facebookError = $error;
        	$datavalid = false;
	}

	if ($datavalid && !isvalidtwitter($mytwitter, $error))
	{
		$twitterError = $error;
        	$datavalid = false;
	}

    	if ($datavalid && !isvalidlinkedin($mylinkedin, $error))
    	{
        	$linkedinError = $error;
        	$datavalid = false;
    	}

	if ($datavalid && !isvalidgithub($mygithub, $error))
    	{
        	$githubError = $error;
        	$datavalid = false;
    	}

	if ($datavalid && !isvalidinstagram($myinstagram, $error))
	{
		$instagramError = $error;
        	$datavalid = false;
	}

    if ($datavalid && !isvalidyoutube($myyoutube, $error))
	{
		$youtubeError = $error;
        	$datavalid = false;
	}

    	if ($datavalid && !isValidTelephoneNumber($mywhatsapp) && $mywhatsapp!="") 
	{
		$whatsapperror = "Invalid mobile phone";
		$datavalid = false;
	} 
    
	if ($datavalid && !isValidTelephoneNumber($myviber) && $myviber!="") 
	{
		$vibererror = "Invalid mobile phone";
		$datavalid = false;
	} 

	if ($datavalid && !isvalidsnapchat($mysnapchat, $error))
	{
		$snapchaterror = $error;
        	$datavalid = false;
	}

    if ($datavalid)
    {
        $myprofile["Social"]["Facebook"] = $myfacebook;
        $myprofile["Social"]["Twitter"] = $mytwitter;
        $myprofile["Social"]["Linkedin"] = $mylinkedin;
        $myprofile["Social"]["Github"] = $mygithub;
        $myprofile["Social"]["Skype"] = $myskype;
        $myprofile["Social"]["Youtube"] = $myyoutube;
        $myprofile["Social"]["Instagram"] = $myinstagram;
        $myprofile["Social"]["Whatsapp"] = $mywhatsapp;
        $myprofile["Social"]["Viber"] = $myviber;
        $myprofile["Social"]["Snapchat"] = $mysnapchat;

        if (!saveProfile($userid,$myprofile,$error,$useraeskey))
        {
            echo "Could not save profile $error";
            exit;
        }

		$formVisible = false;
		$resultVisible = true;
		$content = displaySuccess("Details updated successfully",null,"Go to profile",  $returnpage."&userid=$userid");
	}
}

//**************************************************************
// Design
//**************************************************************


if ($resultVisible) 
{
	echo $content; 
	return;
}

$formvis = ($formVisible) ? "block" : "none";
$facebook = $myprofile["Social"]["Facebook"];
$linkedin = $myprofile["Social"]["Linkedin"];
$github = $myprofile["Social"]["Github"];
$instagram = $myprofile["Social"]["Instagram"];
$twitter = $myprofile["Social"]["Twitter"];
$whatsapp = array_key_exists("Whatsapp",$myprofile["Social"])? $myprofile["Social"]["Whatsapp"] : "";
$viber = array_key_exists("Viber",$myprofile["Social"])? $myprofile["Social"]["Viber"] : "";
$snapchat = array_key_exists("Snapchat",$myprofile["Social"]) ? $myprofile["Social"]["Snapchat"] : "";
$skype= array_key_exists("Skype",$myprofile["Social"]) ?  $myprofile["Social"]["Skype"] : "";
$youtube= array_key_exists("Youtube",$myprofile["Social"]) ?  $myprofile["Social"]["Youtube"] : "";

$frm=<<<FRMSOCIAL

 <div class="col-md-6 p-0" style="display: $formvis">
    <div class="card">
        <div class="card-header">
            <h4 class="m-0">Edit my social media details</h4>
        </div>
        <div class="card-body bg-light pt-2">
            <form enctype="multipart/form-data" action="index.php" method="POST" novalidate>
		<input type="hidden" name="owpn" value="$owpn">
                <input type="hidden" name="userid" value="$userid" />
                <input type="hidden" name="useraeskey" value="$useraeskey" />
                <input type="hidden" name="returnpage" value="$returnpage" />
		<input type="hidden" name="myaction" value="updatesocial">

                <!-- Facebook -->
                <div class="input-group mb-0"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/facebook.png" class="" style="margin-left: 2px; margin-right: 3px;" border=0 width="15px"/></span>
                    <input class="form-control" name="myfacebook" type="text" placeholder="https://www.facebook.com/myuser/" aria-label="Facebook" aria-describedby="basic-addon1" value="$facebook">
                </div>
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold">$facebookError</div>
                
                <!-- Linkedin -->
                <div class="input-group mb-0"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/linkedin.png" class="" border=0 width="20px"/></span>
                    <input class="form-control" name="mylinkedin" type="text" placeholder="https://www.linkedin.com/in/myuser/" aria-label="LinkedIn" aria-describedby="basic-addon1" value="$linkedin">
                </div>
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold">$linkedinError</div>

                <!-- Github -->
                <div class="input-group mb-0"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/github.png" class="" style="margin-left: 2px; margin-right: 3px;" border=0 width="15px"/></span>
                    <input class="form-control" name="mygithub" type="text" placeholder="https://www.github.com/myuser/" aria-label="GitHub" aria-describedby="basic-addon1" value="$github">
                </div>
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold">$githubError</div>

                <!-- Instagram -->
                <div class="input-group mb-0"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/instagram.png" class="" style="margin-left: 2px; margin-right: 3px;" border=0 width="15px"/></span>
                    <input class="form-control" name="myinstagram" type="text" placeholder="https://www.instagram.com/myuser/" aria-label="Instagram" aria-describedby="basic-addon1" value="$instagram">
                </div>
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold">$instagramError</div>  

                <!-- Youtube -->
                <div class="input-group mb-0"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/youtube.png" class="" style="margin-left: 2px; margin-right: 3px;" border=0 width="15px"/></span>
                    <input class="form-control" name="myyoutube" type="text" placeholder="https://www.youtube.com/@myuser/" aria-label="Youtube" aria-describedby="basic-addon1" value="$youtube">
                </div>
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold">$youtubeError</div> 
                
                 <!-- Whatsapp -->
                 <div class="input-group mb-0"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/whatsapp.png" class="" style="margin-left: 2px; margin-right: 3px;" border=0 width="15px"/></span>
                    <input class="form-control" name="mywhatsapp" type="text" placeholder="+36201234567" aria-label="Whatsapp" aria-describedby="basic-addon1" value="$whatsapp">
                </div>
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold">$whatsapperror</div>

                 <!-- Viber -->
                 <div class="input-group mb-0"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/viber.png" class="" style="margin-left: 2px; margin-right: 3px;" border=0 width="15px"/></span>
                    <input class="form-control" name="myviber" type="text" placeholder="+36201234567" aria-label="Viber" aria-describedby="basic-addon1" value="$viber">
                </div>
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold">$vibererror</div>
                
                 <!-- Snapchat -->
                 <div class="input-group mb-0"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/snapchat.svg" class="" style="margin-left: 2px; margin-right: 3px;" border=0 width="15px"/></span>
                    <input class="form-control" name="mysnapchat" type="text" placeholder="https://www.snapchat.com/myuser" aria-label="Snapchat" aria-describedby="basic-addon1" value="$snapchat">
                </div>
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold">$snapchaterror</div>
                
                <!-- Twitter -->
                <div class="input-group mb-0"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/twitter.png" class="" border=0 width="20px"/></span>
                    <input class="form-control" name="mytwitter" type="text" placeholder="https://www.twitter.com/myuser/" aria-label="Twitter" aria-describedby="basic-addon1" value="$twitter">
                </div>
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold">$twitterError</div>
                       
                <!-- Skype -->
                <div class="input-group mb-0"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/skype.png" class="" style="margin-left: 2px; margin-right: 3px;" border=0 width="15px"/></span>
                    <input class="form-control" name="myskype" type="text" placeholder="Skype" aria-label="Skype" aria-describedby="basic-addon1" value="$skype">
                </div>
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold">$skypeError</div>
                         
                <!-- OK -->
                <button class="btn btn-primary mt-2" type="submit" name="socialmedia-submit">Update</button>
            </form>
        </div>
    </div>
</div>

FRMSOCIAL;

echo $frm;
?>
