<?php
//**********************************************************
// Edit professional skills
//**********************************************************

function createSkill() : array
{
    $skill["Skill"] = "";
    $skill["Description"] = "";
    return $skill;
}

//**********************************************************
// Edit educational background
//**********************************************************
global $useraeskey,$returnpage,$userid,$myaction;
loadOptionalRequestParameters("useraeskey","returnpage","userid");
if (isEmpty($returnpage)) $returnpage = $page_profile_myprofile;

loadOrCreateProfile($userid,$myprofile,$error,$useraeskey);

$formVisible = true;
$resultVisible = false;

loadMyAction();
$position = -1;

if ($myaction=="delskill")
{
    global $myprofile;

    $position = $_POST["postodel"];
    array_splice($myprofile["Skill"], $position, 1);
    saveProfile($userid,$myprofile,$error,$useraeskey);
}

if ($myaction=="addskill")
{
    global $myprofile;

    if (!is_array($myprofile["Skill"])) $myprofile["Skill"] = [];
    $position = count($myprofile["Skill"]);
    $myprofile["Skill"][$position] = createSkill();
    $myprofile["Skill"][$position]["Skill"] = $_POST["skill"];
    $myprofile["Skill"][$position]["Description"] = $_POST["Description"];
    
    if (!isEmpty($myprofile["Skill"][$position]["Skill"])) 
    {
        saveProfile($userid,$myprofile,$error,$useraeskey);
    }
}

if ($myaction=="updateskill")
{
    if ($position==-1) $position = $_POST["skillposition"];
    $myprofile["Skill"][$position]["Skill"] = $_POST["skill"];
    $myprofile["Skill"][$position]["Description"] = $_POST["Description"];

    if (!isEmpty($myprofile["Skill"][$position]["Skill"])) 
    {
        saveProfile($userid,$myprofile,$error,$useraeskey);
    }
}

//**********************************************************
// Form components
//**********************************************************

function displayDelButton($position) : string
{
    global $owpn, $userid, $useraeskey, $returnpage;

    return <<<ENDDELBUTTON
    <form action="index.php" method="post" novalidate>
        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="postodel" value="$position" />
        <input type="hidden" name="myaction" value="delskill" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <button class="btn btn-sm btn-default mt-0 collapsed border" type="submit">Remove</button>
    </form>
ENDDELBUTTON;
}

function displayAddButton() : string
{
    global $owpn, $userid, $useraeskey, $returnpage;

    return <<<ENDADDBUTTON
    <form action="index.php" method="post" novalidate>
        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="myaction" value="displayaddnew"/>
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <button class="btn btn-primary mt-2" type="submit">Add</button>
    </form>
ENDADDBUTTON;
}

function displayCurrent($position) : string
{
    global $owpn, $myprofile;
    $skill = htmlspecialchars($myprofile["Skill"][$position]["Skill"]);
    $ability = htmlspecialchars($myprofile["Skill"][$position]["Description"]);

    return <<<ENDED
    <p class="mt-2 mb-1"><strong>$skill</strong></p>
    <p class="mt-1 mb-2">$ability</p>
ENDED;
}

function displayAddNewForm() : string
{
    global $myprofile, $owpn, $userid, $useraeskey, $returnpage;

    if(!is_array($myprofile["Skill"]))
	    $position = 0;
    else
	    $position = count($myprofile["Skill"]);

    return <<<ENDADDNEWFORM

    <div>
    <form action="index.php" method="POST" novalidate>

        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="myaction" value="addskill" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />

        <div class="border p-card rounded mt-2">

            <div class="mb-3">
                <label class="form-label" for="text">Skill</label>
                <input class="form-control" name="skill"  id="skill" type="text" aria-label="skill" aria-describedby="basic-addon1" />
            </div>

            <div class="mb-3">
                <label class="form-label" for="text">Description</label>
                <textarea class="form-control" name="Description"  id="Description" aria-label="skill_ability" aria-describedby="basic-addon1"></textarea>
            </div>

        <button class="btn btn-primary mt-2" type="submit">OK</button>
        </div>
    </form>

    <form action="index.php" method="post" novalidate>
        <input type="hidden" name="owpn" value="$returnpage" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="myaction" value="" />
        <button class="btn btn-danger mt-2" type="submit">Close</button>
    </form>
    </div>
ENDADDNEWFORM;
}

function displaySkillForm($position) : string
{
    global $owpn, $myprofile, $userid, $useraeskey, $returnpage;

    global $owpn, $myprofile;
    $skill = htmlspecialchars($myprofile["Skill"][$position]["Skill"]);
    $ability = htmlspecialchars($myprofile["Skill"][$position]["Description"]);
    $del = displayDelButton($position);
    $list = displayCurrent($position);

    if (isEmpty($myprofile["Skill"][$position]["Skill"])) return "";
    

    return <<<ENDFORM

    <div class="mb-3">
    
        $list
        <div style="display: flex; flex-direction: row;">
            <a class="btn btn-sm btn-default mt-0 collapsed border" data-bs-toggle="collapse"
             href="#collapseEditSkill$position" role="button" aria-expanded="false"
             aria-controls="collapseEditSkill$position">Edit</a>
             $del
        </div>

        <form action="index.php" method="post" novalidate>
        
            <input type="hidden" name="owpn" value="$owpn" />
            <input type="hidden" name="userid" value="$userid" />
            <input type="hidden" name="skillposition" value="$position" />
            <input type="hidden" name="myaction" value="updateskill" />
            <input type="hidden" name="useraeskey" value="$useraeskey" />
            <input type="hidden" name="returnpage" value="$returnpage" />

            <div class="collapse" id="collapseEditSkill$position">
                <div class="border p-card rounded mt-2">
                
                <div class="mb-3">
                    <label class="form-label" for="text">Skill</label>
                    <input class="form-control" name="skill"  id="skill" type="text" aria-label="skill_skill" aria-describedby="basic-addon1" value="$skill" />
                </div>

                <div class="mb-3">
                    <label class="form-label" for="text">Description</label>
                    <textarea class="form-control" name="Description"  id="Description" aria-label="skill_ability" aria-describedby="basic-addon1">$ability</textarea>
                </div>
                    
                <button class="btn btn-primary mt-2" type="submit">OK</button>
                    
                </div>
            </div>      
        </form>
    </div>

ENDFORM;
}

//**********************************************************
// Design
//**********************************************************
?>

<div class="col-md-6 p-0" style="display: <?php echo ($formVisible) ? "block" : "none"; ?>">
    <div class="card">
        <div class="card-header">
            <h4 class="m-0">Skills</h4>
        </div>
        <div class="card-body bg-light pt-2">
            <p>You can add skills, such as leadership, problem solving, time management, etc...</p>
            <?php
                $skill = $myprofile["Skill"];
                
                if (is_array($skill))
                foreach($skill as $position=>$value)
                {
                    echo displaySkillForm($position);
                }

                if ($myaction=="displayaddnew")
                {
                    echo displayAddNewForm();
                }
                else
                {
                    echo displayAddButton();
                }
            ?>
        </div>
    </div>
</div>