<?php

//**************************************************************
// Update profile image
//**************************************************************
include_once("$sysdir/base/image.php");
include_once("$dirprefix/ozekiservices/profile/common/profileimage.php");

function get_profileimagedir($userid)
{
	global $regdir;
	return "$regdir/$userid/profile/image";
}

global $userid,$returnpage,$myaction,$profile_image_encrypted;
loadOptionalRequestParameters("userid","returnpage");
if(empty($returnpage))$returnpage=$page_profile_myprofile;

if (!isDecisionMaker()) $userid = $myuserid;

$formVisible = true;
$resultVisible = false;

global $myaction,$datadir;
loadReqParams("myaction");
if($myaction==="updateprofileimage")
{
    if(!isset($_FILES["profileimage"]))
    {
        echo "No uploaded file data received.";
        exit;
    }
    if(!profile_updateprofileimage($userid,$_FILES["profileimage"],$details,$error)){
        echo $error;
        exit;
    }
    $formVisible=false;
    $resultVisible=true;
    $content=displaySuccess("Profile picture updated",null,"Go to profile","$returnpage&userid=$userid");
}

if($myaction==="deleteprofileimage")
{
    if(!profile_deleteprofileimage($userid,$error)){
        echo $error;
        exit;
    }
    $formVisible=false;
    $resultVisible=true;
    $content=displaySuccess("Profile picture removed",null,"Go to profile","$returnpage&userid=$userid");
}

if($myaction==="nochange")
{
    $formVisible=false;
    $resultVisible=true;
    $content=displaySuccess("Nothing changed",null,"Go to profile","$returnpage&userid=$userid");
}

?>

<?php if ($resultVisible) echo $content; ?>
<div class="col-md-6 p-0" style="display: <?php echo ($formVisible) ? "block" : "none"; ?>">
    <div class="card">
        <div class="card-header">
            <h4 class="m-0">Pick a profile picture</h4>
        </div>
        <div class="card-body bg-light pt-2">
            <div class="d-flex justify-content-center">
                <?php echo getProfileImage($myfullname,$myaesshared,$userid) ?>
            </div>
            <div class="list-group mt-2">
                <input type="file" id="input-profileimagetmp" accept="image/jpeg,image/png,image/webp" class="d-none">
                <button type="button" class="list-group-item list-group-item-action" id="btn-take-photo">Take photo</button>
                <button type="button" class="list-group-item list-group-item-action" id="btn-choose-photo">Choose existing photo</button>
                <button type="button" class="list-group-item list-group-item-action <?php 
                if (!getProfileImagePath($userid,$pofileimage,$errimg)) {echo " d-none";}
                else if(!file_exists($datadir.$pofileimage)) {echo" d-none";}
                ?>" id="btn-delete-photo">Delete photo</button>
            </div>
            <form enctype="multipart/form-data" action="index.php" method="POST" class="m-0" novalidate>
                <input type="file" name="profileimage" accept="image/jpeg,image/png,image/webp" class="d-none">
                <input type="hidden" name="userid" value="<?php echo $userid;?>">
                <input type="hidden" name="owpn" value="<?php echo $owpn;?>">
                <input type="hidden" name="returnpage" value="<?php echo $returnpage;?>">
                <input type="hidden" name="myaction" value="nochange">
                <button type="submit" name="contact-submit" class="btn btn-primary mt-2">Save</button>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-takephoto" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content position-relative">
            <div class="position-absolute top-0 end-0 mt-2 me-2 z-index-1">
                <button class="btn-close btn btn-sm btn-circle d-flex flex-center transition-base" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <div class="rounded-top-lg py-3 ps-4 pe-6 bg-light">
                    <h4 class="mb-1">Take photo</h4>
                </div>
                <div class="">
                    <video id="video-cam" width="100%">Your browser does not support the video tag.</video>
                    <img id="image-cam" width="100%" class="d-none">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn disabled" id="btn-retry">Retry</button>
                <button type="button" class="btn btn-primary" id="btn-take-photo-now">Take photo</button>
                <button type="button" class="btn btn-primary disabled" id="btn-save">Save</button>
            </div>
        </div>
    </div>
</div>

<script>

const SIZE_MAX_WIDTH = 500;
const SIZE_MAX_HEIGHT = 500;

const $avatarContainer = document.querySelector('.avatar-5xl').parentElement;
const $profileImageTmpInput = document.getElementById('input-profileimagetmp');
const $profileImageInput = document.querySelector('input[name="profileimage"]');
const $takePhotoButton = document.getElementById('btn-take-photo');
const $choosePhotoButton = document.getElementById('btn-choose-photo');
const $deletePhotoButton = document.getElementById('btn-delete-photo');
const $retryButton = document.getElementById('btn-retry');
const $takePhotoNowButton = document.getElementById('btn-take-photo-now');
const $saveButton = document.getElementById('btn-save');
const $camVideo = document.getElementById('video-cam');
const $camImage = document.getElementById('image-cam');
let webcamStream = null;
let camSnapshotBlob = null;
let profileImageBlobUrl = null;

checkVideoInput();

$('#modal-takephoto').on('hidden.bs.modal', () => {
    closeWebcamStream();
    camSnapshotBlob = null;
    if ($camVideo.src) URL.revokeObjectURL($camVideo.src);
    if ($camImage.src) URL.revokeObjectURL($camImage.src);
    $retryButton.classList.add('disabled');
    $takePhotoNowButton.classList.remove('disabled');
    $saveButton.classList.add('disabled');
    $camImage.classList.add('d-none');
    $camVideo.classList.remove('d-none');
});

$camVideo.addEventListener('loadedmetadata', () => {
    $camVideo.play();
});

$profileImageTmpInput.addEventListener('change', async (event) => {
    if (profileImageBlobUrl) URL.revokeObjectURL(profileImageBlobUrl);
    const f = event.currentTarget.files[0];
    if (!f) return;
    const img = await fileToImage(f);
    if (!img) return;
    const blob = await resizeImage(img);
    if (!blob) return;
    replaceInputProfileImage(blob);
    setMyAction('updateprofileimage');
    displayProfileImage(blob);
    $deletePhotoButton.classList.remove('d-none');
});

$choosePhotoButton.addEventListener('click', () => {
    $profileImageInput.value = '';
    $profileImageTmpInput.click();
});

$takePhotoButton.addEventListener('click', async () => {
    try {
        const stream = await openWebcamStream();
        displayVideoStream(stream)
        $('#modal-takephoto').modal('show');
    } catch (error) {
        $takePhotoButton.disabled = true;
    }
});

$deletePhotoButton.addEventListener('click', () => {
    if (profileImageBlobUrl) URL.revokeObjectURL(profileImageBlobUrl);
    setMyAction('deleteprofileimage');
    $avatarContainer.innerHTML = getHtmlAvatarInitials();
    $deletePhotoButton.classList.add('d-none');
});

$retryButton.addEventListener('click', async () => {
    const stream = await openWebcamStream();
    displayVideoStream(stream);
    $camImage.classList.add('d-none');
    $camVideo.classList.remove('d-none');
    $retryButton.classList.add('disabled');
    $takePhotoNowButton.classList.remove('disabled');
    $saveButton.classList.add('disabled');
});

$takePhotoNowButton.addEventListener('click', async () => {
    $takePhotoNowButton.classList.add('disabled');
    camSnapshotBlob = await takeSnapshow();
    closeWebcamStream();
    if ($camVideo.src) URL.revokeObjectURL($camVideo.src);
    if ($camImage.src) URL.revokeObjectURL($camImage.src);
    if (!camSnapshotBlob) return;
    $camImage.src = URL.createObjectURL(camSnapshotBlob);
    $camVideo.classList.add('d-none');
    $camImage.classList.remove('d-none');
    $retryButton.classList.remove('disabled');
    $saveButton.classList.remove('disabled');
});

$saveButton.addEventListener('click', () => {
    replaceInputProfileImage(camSnapshotBlob);
    setMyAction('updateprofileimage');
    displayProfileImage(camSnapshotBlob);
    $deletePhotoButton.classList.remove('d-none');
    $('#modal-takephoto').modal('hide');
});

function replaceInputProfileImage(blob) {
    const f = new File([blob], "profile_picture", { type: blob.type });
    const dt = new DataTransfer();
    dt.items.add(f);
    $profileImageInput.files = dt.files;
}

function setMyAction(action) {
    const input = document.querySelector('input[name="myaction"]');
    if (!input) return;
    input.value = action;
}

function displayVideoStream(stream) {
    if ('srcObject' in $camVideo)
        $camVideo.srcObject = stream;
    else
        $camVideo.src = window.URL.createObjectURL(stream);
}

function displayProfileImage(blob) {
    profileImageBlobUrl = URL.createObjectURL(blob);
    $avatarContainer.innerHTML = getHtmlAvatar(profileImageBlobUrl);
}

async function openWebcamStream() {
    if (webcamStream) closeWebcamStream();
    webcamStream = await getWebcamStream();
    return webcamStream;
}

function closeWebcamStream() {
    if (!webcamStream) return;
    for (const t of webcamStream.getTracks())
        t.stop();
    webcamStream = null;
}

function getWebcamStream() {
    return navigator.mediaDevices.getUserMedia({
        video: {
            width: { ideal: 1280 },
            height: { ideal: 720 },
            facingMode: 'user',
        }
    });
}

async function checkVideoInput() {
    try {
        const devices = await navigator.mediaDevices.enumerateDevices();
        const videoInput = devices.find(d => d.kind === 'videoinput');
        if (!videoInput) throw new Error("No video input found.");
    } catch (error) {
        $takePhotoButton.remove();
    }
}

function takeSnapshow() {
    const canvas = document.createElement('canvas');
    canvas.width = $camVideo.videoWidth;
    canvas.height = $camVideo.videoHeight;
    const ctx = canvas.getContext('2d');
    ctx.drawImage($camVideo, 0, 0);
    return resizeImage(canvas);
}

function resizeImage(img) {
    const dims = getScaledDims(img.width, img.height, SIZE_MAX_WIDTH, SIZE_MAX_HEIGHT);
    const canvas = document.createElement('canvas');
    canvas.width = dims.width;
    canvas.height = dims.height;
    const ctx = canvas.getContext('2d');
    ctx.drawImage(img, 0, 0, img.width, img.height, 0, 0, dims.width, dims.height);
    return canvasToBlob(canvas);
}

function fileToImage(f) {
    return new Promise((resolve) => {
        const img = new Image();
        img.onload = () => {
            URL.revokeObjectURL(img.src);
            resolve(img);
        };
        img.onerror = () => resolve(null);
        img.src = URL.createObjectURL(f);
    });
}

function canvasToBlob(canvas) {
    return new Promise((resolve) => {
        if (isRunningInSafari())
            canvas.toBlob((blob) => resolve(blob), 'image/jpeg', 0.73);
        else
            canvas.toBlob((blob) => resolve(blob), 'image/webp', 0.93);
    });
}

function getScaledDims(width, height, maxWidth, maxHeight) {
    if (width <= maxWidth && height <= maxHeight)
        return { width: width, height: height };
    const diffWidth = maxWidth - width;
    const diffHeight = maxHeight - height;
    if (diffWidth > diffHeight)
        return { width: width * (maxHeight / height), height: maxHeight };
    else
        return { width: maxWidth, height: height * (maxWidth / width) };
}

function getHtmlAvatar(imgSrc) {
    return `
<div class="avatar avatar-5xl">
	<img class="rounded-circle img-thumbnail shadow-sm" src="${imgSrc}" width="200" alt>
</div>
`;
}

function getHtmlAvatarInitials() {
    return `<?php echo getProfileImage_initials($myfullname);?>`;
}

function isRunningInSafari() {
    const ua = navigator.userAgent.toLowerCase();
    if (ua.indexOf('safari/') == -1) return false;
    if (ua.indexOf('chrome/') > -1) return false;
    return true;
}

</script>
