<?php

//**************************************************************
// Edit name
//**************************************************************
global $useraeskey,$returnpage,$userid,$myaction;
loadOptionalRequestParameters("useraeskey","returnpage","userid");
if (isEmpty($returnpage)) $returnpage = $page_profile_myprofile;

loadOrCreateProfile($userid,$myprofile,$error,$useraeskey);

$formVisible = true;
$resultVisible = false;
$nameError="";
$websiteError = "";

function isvalidurl($mycompanywebsite, &$error) : bool
    {
    if (strlen($mycompanywebsite)==0) return true;
    
    if (!filter_var($mycompanywebsite, FILTER_VALIDATE_URL)) 
    {
        $error = "This is not a valid url";
        return false;
    }

    if (!ozstartswith(strtolower($mycompanywebsite),"http"))
    {
        $error = "This is not a valid url";
        return false;
    }
    return true;
    }

loadMyAction();
if ($myaction=="updatedetails")
{
    $myname = $_POST["myname"];
    $mynick = $_POST["mynick"];
    $mycompany = $_POST["mycompany"];
    $myposition = $_POST["myposition"];
    $mycompanywebsite = $_POST["mycompanywebsite"];

    $datavalid=true;
    if ($datavalid && strlen($myname)==0)
    {
        $nameError = 'The provided name was not valid';
        $datavalid = false;
    }

	if ($datavalid && !isvalidurl($mycompanywebsite, $error))
	{
		$websiteError = $error;
        	$datavalid = false;
	}

    if ($datavalid)
    {
        $myprofile["Personal"]["Name"] = $myname;
        $myprofile["Personal"]["Nick"] = $mynick;
        $myprofile["Personal"]["Company"] = $mycompany;
        $myprofile["Personal"]["CompanyWebsite"] = $mycompanywebsite;
        $myprofile["Personal"]["Position"] = $myposition;
 
        //Update publicly visible name
        updatePublicDetails($userid,$myname,$mynick);
        
        //Update name and nick in registration details
        loadUserDetails($userid,$details,$error,$useraeskey); 
        $details["fullname"] = $myname;
        $details["nick"] = $mynick;
        if (!updateUserDetails($userid,$details,$error,$useraeskey))
        {
            echo "Could not update profile $error";
            return;
        }
        
        //Update the profile
        if (!saveProfile($userid,$myprofile,$error,$useraeskey))
        {
            echo "Could not save profile $error";
            return;
        }

        $formVisible = false;
        $resultVisible = true;
        echo displaySuccess("Details updated successfully",null,"Go to profile", $returnpage."&userid=$userid");
    }
}

//**************************************************************
// Name
//**************************************************************
$companyWebsite = array_key_exists("CompanyWebsite",$myprofile["Personal"]) ? $myprofile["Personal"]["CompanyWebsite"] : "";
?>

<div class="col-md-6 p-0 mb-4" style="display: <?php echo ($formVisible) ? "block" : "none"; ?>">
    <div class="card">
        <div class="card-header">
            <h4 class="m-0">Full name</h4>
        </div>
        <div class="card-body bg-light pt-2">
            <form enctype="multipart/form-data" action="index.php" method="POST" novalidate>
                <input type="hidden" name="owpn" value="<?php echo $owpn;?>">
                <input type="hidden" name="userid" value="<?php echo $userid;?>" />
                <input type="hidden" name="useraeskey" value="<?php echo $useraeskey;?>" />
                <input type="hidden" name="returnpage" value="<?php echo $returnpage;?>" />
                <input type="hidden" name="myaction" value="updatedetails">

                <!-- Name -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/name.svg" alt="name.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="myname" type="text" placeholder="Name" aria-label="Name" aria-describedby="basic-addon1" value="<?php echo $myprofile["Personal"]["Name"]; ?>">
                </div>
                <div class="form-label mb-3 mt-0"  style="color:red; font-weight:bold"><?php echo $nameError;?></div>

                <!-- Nick -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/name.svg" alt="name.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="mynick" type="text" placeholder="Nickname" aria-label="Nickname" aria-describedby="basic-addon1" value="<?php echo $myprofile["Personal"]["Nick"] ?? ""; ?>">
                </div>

                <!-- Company -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/company.svg" alt="company.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="mycompany" type="text" placeholder="Company" aria-label="Company" aria-describedby="basic-addon1" value="<?php echo $myprofile["Personal"]["Company"] ?? ""; ?>">
                </div>

                <!-- CompanyWebsite -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/website.svg" alt="company.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="mycompanywebsite" type="text" placeholder="http://www.mycompany.com" aria-label="CompanyWebsite" aria-describedby="basic-addon1" value="<?php echo $companyWebsite; ?>">
                </div>                
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold"><?php echo $websiteError;?></div>

                <!-- Position -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/position.svg" alt="position.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="myposition" type="text" placeholder="Position" aria-label="Position" aria-describedby="basic-addon1" value="<?php echo $myprofile["Personal"]["Position"] ?? ""; ?>">
                </div>

                <!-- OK -->
                <button class="btn btn-primary mt-2" type="submit" name="contact-submit">Save</button>
            </form>
        </div>
    </div>
</div>
