<?php

function createLanguage() : array
{
    $lang["Language"] = "";
    $lang["Certification"] = "";
    $lang["Experience"] = "";
    return $lang;
}

//**********************************************************
// Edit languages
//**********************************************************
global $useraeskey,$returnpage,$userid,$myaction;
loadOptionalRequestParameters("useraeskey","returnpage","userid");
if (isEmpty($returnpage)) $returnpage = $page_profile_myprofile;

loadOrCreateProfile($userid,$myprofile,$error,$useraeskey);

$formVisible = true;
$resultVisible = false;

loadMyAction();
$position = -1;

if ($myaction=="dellanguage")
{
    global $myprofile;

    $position = $_POST["postodel"];
    array_splice($myprofile["Language"], $position, 1);
    saveProfile($userid,$myprofile,$error,$useraeskey);
}

if ($myaction=="addlanguage")
{
    global $myprofile;

    if (!is_array($myprofile["Language"])) $myprofile["Language"] = [];
    $position = count($myprofile["Language"]);
    $myprofile["Language"][$position] = createLanguage();
    $myprofile["Language"][$position]["Language"] = $_POST["language"];
    $myprofile["Language"][$position]["Certification"] = $_POST["certification"];
    $myprofile["Language"][$position]["Experience"] = $_POST["experience"];

    if (!isEmpty($myprofile["Language"][$position]["Language"]))
    {
        saveProfile($userid,$myprofile,$error,$useraeskey);
    }
}

if ($myaction=="updatelanguage")
{	
    if ($position==-1) $position = $_POST["langposition"];
    $myprofile["Language"][$position]["Language"] = $_POST["language"];
    $myprofile["Language"][$position]["Certification"] = $_POST["certification"];
    $myprofile["Language"][$position]["Experience"] = $_POST["experience"];

    if (!isEmpty($myprofile["Language"][$position]["Language"]))
    {
        saveProfile($userid,$myprofile,$error,$useraeskey);
    }

}

function displayDelButton($position) : string
{
    global $owpn, $userid, $useraeskey, $returnpage;

    return <<<ENDDELBUTTON
    <form action="index.php" method="post" novalidate>
        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="postodel" value="$position" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <input type="hidden" name="myaction" value="dellanguage" />
        <button class="btn btn-sm btn-default mt-0 collapsed border" type="submit">Remove</button>
    </form>
ENDDELBUTTON;
}

function displayAddButton() : string
{
    global $owpn, $userid, $useraeskey, $returnpage;

    return <<<ENDADDBUTTON
    <form action="index.php" method="post" novalidate>
        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <input type="hidden" name="myaction" value="displayaddnew"/>
        <button class="btn btn-primary mt-2" type="submit">Add</button>
    </form>
ENDADDBUTTON;
}

function displayCurrent($position) : string
{
    global $owpn, $myprofile;
    $language=htmlspecialchars($myprofile["Language"][$position]["Language"]);
    $certification=htmlspecialchars($myprofile["Language"][$position]["Certification"]);
    $experience=htmlspecialchars($myprofile["Language"][$position]["Experience"]);

    return <<<ENDLANG
    <p class="mt-2 mb-1"><strong>$language</strong></p>
	<p class="mt-1 mb-2">$certification</p>
	<p class="mt-1 mb-2">$experience</p>
ENDLANG;
}


function displayAddNewForm() : string
{
    global $myprofile, $owpn, $userid, $useraeskey, $returnpage;

    if(!is_array($myprofile["Language"]))
	    $position = 0;
    else
        $position = count($myprofile["Language"]);
	
    return <<<ENDADDNEWFORM
	<div>
		<form action="index.php" method="POST" novalidate>

			<input type="hidden" name="owpn" value="$owpn" />
            <input type="hidden" name="userid" value="$userid" />
			<input type="hidden" name="myaction" value="addlanguage" />
            <input type="hidden" name="useraeskey" value="$useraeskey" />
            <input type="hidden" name="returnpage" value="$returnpage" />

			<div class="border p-card rounded mt-2">

				<div class="mb-3">
					<label class="form-label" for="text">Language</label>
					<input class="form-control" name="language"  id="language" type="text"
						   aria-label="lang_language" aria-describedby="basic-addon1" />
				</div>

				<div class="mb-3">
					<label class="form-label" for="text">Certification</label>
					<input class="form-control" name="certification"  id="certification"
						   type="text" aria-label="lang_certification" aria-describedby="basic-addon1" />
				</div>
				
				<div class="mb-3">
					<label class="form-label" for="text">Experience</label>
					<textarea class="form-control" name="experience" id="experience" placeholder="Write here..." rows="4"></textarea>                
				</div>

				<button class="btn btn-primary mt-2" type="submit">Add</button>
			</div>
		</form>

		<form action="index.php" method="post" novalidate>
			<input type="hidden" name="owpn" value="$returnpage" />
            <input type="hidden" name="userid" value="$userid" />
			<input type="hidden" name="myaction" value="" />
			
			<button class="btn btn-danger mt-2" type="submit">Close</button>
		</form>
	</div>
ENDADDNEWFORM;
}

function displayLangForm($position) 
{
	global $owpn, $myprofile, $userid, $useraeskey, $returnpage;

    $language=htmlspecialchars($myprofile["Language"][$position]["Language"]);
    $certification=htmlspecialchars($myprofile["Language"][$position]["Certification"]);
    $experience=htmlspecialchars($myprofile["Language"][$position]["Experience"]);
    $del = displayDelButton($position);
    $list = displayCurrent($position);

    if (isEmpty($myprofile["Language"][$position]["Language"])) return "";

    return <<<ENDFORM
	<div class="mb-3">			
		$list
		<div style="display: flex; flex-direction: row;">
			<a class="btn btn-sm btn-default mt-0 collapsed border" data-bs-toggle="collapse" href="#collapseEditLanguage$position" role="button" aria-expanded="false" aria-controls="collapseEditLanguage$position">Edit</a>
			$del
		</div>
		
		<form action="index.php" method="post" novalidate>
		
			<input type="hidden" name="owpn" value="$owpn" />
            <input type="hidden" name="userid" value="$userid" />
			<input type="hidden" name="langposition" value="$position" />
			<input type="hidden" name="myaction" value="updatelanguage" />
            <input type="hidden" name="useraeskey" value="$useraeskey" />
            <input type="hidden" name="returnpage" value="$returnpage" />
		
            <div class="collapse" id="collapseEditLanguage$position">
                <div class="border p-card rounded mt-2">
                    <div class="mb-3">
                        <label class="form-label" for="text">Language</label>
                        <input class="form-control" type="text" name="language" id="language" aria-label="language" aria-describedby="basic-addon1" value="$language">
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="text">Certification</label>
                        <input class="form-control" type="text" name="certification" id="certification" aria-label="language" aria-describedby="basic-addon1" value="$certification">
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="text">Experience</label>
                        <textarea class="form-control" name="experience" id="experience" rows="3">$experience</textarea>
                    </div>
                    <button class="btn btn-primary mt-2" type="submit">Save</button>
                </div>
            </div>
        </form>
	</div>
ENDFORM;
}

//**********************************************************
// Design
//**********************************************************
?>

<div class="col-md-6 p-0" style="display: <?php echo ($formVisible) ? "block" : "none"; ?>">
    <div class="card">
        <div class="card-header">
            <h4 class="m-0">Languages</h4>
        </div>
        <div class="card-body bg-light pt-2">
            <?php
                $language = $myprofile["Language"];
                
                if (is_array($language))
                foreach($language as $position=>$value)
                {
                    echo displayLangForm($position);
                }

                if ($myaction=="displayaddnew")
                {
                    echo displayAddNewForm();
                }
                else
                {
                    echo displayAddButton();
                }
            ?>
        </div>
    </div>
</div>