<?php

function createEmployment() : array
{
    $emp["Company"] = "";
    $emp["DateStart"] = "";
    $emp["DateEnd"] = "";
    $emp["Location"] = "";
    $emp["Position"] = "";
    $emp["Tasks"] = "";
    return $emp;
}

//**********************************************************
// Edit employment history
//**********************************************************
global $useraeskey,$returnpage,$userid,$myaction;
loadOptionalRequestParameters("useraeskey","returnpage","userid");
if (isEmpty($returnpage)) $returnpage = $page_profile_myprofile;

loadOrCreateProfile($userid,$myprofile,$error,$useraeskey);

$formVisible = true;
$resultVisible = false;

loadMyAction();
$position = -1;

if ($myaction=="delemployment")
{
    global $myprofile;

    $position = $_POST["postodel"];
    array_splice($myprofile["Employment"], $position, 1);
    saveProfile($userid,$myprofile,$error,$useraeskey);
}

if ($myaction=="addemployment")
{
    global $myprofile;

    if (!is_array($myprofile["Employment"])) $myprofile["Employment"] = [];
    $position = count($myprofile["Employment"]);
    $myprofile["Employment"][$position] = createEmployment();
    $myprofile["Employment"][$position]["Company"] = $_POST["company"];
    $myprofile["Employment"][$position]["DateStart"] = $_POST["datestart"];
    $myprofile["Employment"][$position]["DateEnd"] = $_POST["dateend"];
    $myprofile["Employment"][$position]["Location"] = $_POST["location"];
    $myprofile["Employment"][$position]["Position"] = $_POST["position"];
    $myprofile["Employment"][$position]["Tasks"] = $_POST["tasks"];

    if (!isEmpty($myprofile["Employment"][$position]["Company"])) 
    {
        saveProfile($userid,$myprofile,$error,$useraeskey);
    }
}

if ($myaction=="updateemployment")
{
    if ($position==-1) $position = $_POST["empposition"];
    $myprofile["Employment"][$position]["Company"] = $_POST["company"];
    $myprofile["Employment"][$position]["DateStart"] = $_POST["datestart"];
    $myprofile["Employment"][$position]["DateEnd"] = $_POST["dateend"];
    $myprofile["Employment"][$position]["Location"] = $_POST["location"];
    $myprofile["Employment"][$position]["Position"] = $_POST["position"];
    $myprofile["Employment"][$position]["Tasks"] = $_POST["tasks"];

    if (!isEmpty($myprofile["Employment"][$position]["Company"])) 
    {
        saveProfile($userid,$myprofile,$error,$useraeskey);
    }
}

//**********************************************************
// Form components
//**********************************************************

function displayDelButton($position) : string
{
    global $owpn, $userid, $useraeskey, $returnpage;

    return <<<ENDDELBUTTON
    <form action="index.php" method="Post" novalidate>
        <input type="hidden" name="owpn" value="$owpn" />        
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="postodel" value="$position" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <input type="hidden" name="myaction" value="delemployment" />
        <button class="btn btn-sm btn-default mt-0 collapsed border" type="submit">Remove</button>
    </form>
ENDDELBUTTON;
}


function displayAddButton() : string
{
    global $owpn, $userid, $useraeskey, $returnpage;

    return <<<ENDADDBUTTON
    <form action="index.php" method="Post" novalidate>
        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <input type="hidden" name="myaction" value="displayaddnew"/>
        <button class="btn btn-primary mt-2" type="submit">Add</button>
    </form>
ENDADDBUTTON;
}

function displayCurrent($position) : string
{
    global $owpn, $myprofile;
    $company = $myprofile["Employment"][$position]["Company"];
    $datestart = $myprofile["Employment"][$position]["DateStart"];
    $dateend = $myprofile["Employment"][$position]["DateEnd"];
    $location = $myprofile["Employment"][$position]["Location"];
    $post = $myprofile["Employment"][$position]["Position"];
    $tasks = $myprofile["Employment"][$position]["Tasks"];

    $dates = "";
    if (!isEmpty($datestart) && isEmpty($dateend)) $dates = "<div>$datestart - </div>";
    if (isEmpty($dateSTART) && !isEmpty($dateend)) $dates = "<div> - $dateend</div>" ;
    if (!isEmpty($datestart) && !isEmpty($dateend)) $dates =  "<div>$datestart - $dateend</div>" ;
    
    $post = (!isEmpty($post)) ? "<div style='color:#25068d; font-weight:bold'>$post</div>" : "";
    $location = (!isEmpty($location)) ? "<div>$location</div>" : "";
    $tasks = (!isEmpty($tasks)) ? "<div>$tasks</div>" : "";

    return <<<ENDED
    <div class="mt-3" style='font-weight:bold; color:black'>
        $company
    </div>
        $post
        $dates
        $location
        $tasks
ENDED;
}

function displayAddNewForm() : string
{
    global $myprofile, $owpn, $userid, $useraeskey, $returnpage;
    
    if(!is_array($myprofile["Employment"]))
	    $position = 0;
    else
	    $position = count($myprofile["Employment"]);

    return <<<ENDADDNEWFORM
<div>
    <form action="index.php" method="Post" novalidate>

        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <input type="hidden" name="myaction" value="addemployment" />

        <div class="border p-card rounded mt-2">

            <div class="mb-3">
                <label class="form-label" for="text">Company</label>
                <input class="form-control" name="company"  id="company" type="text"
                       aria-label="company" aria-describedby="basic-addon1" />
            </div>

            <div class="mb-3">
            <label class="form-label" for="text">Position</label>
            <input class="form-control" name="position"  id="Position"
                   type="text" aria-label="Position" aria-describedby="basic-addon1" />
            </div>

            <div class="mb-3">
                <label class="form-label" for="text">Start</label>
                <input class="form-control" name="datestart"  id="datestart" type="date"
                       aria-label="datestart" aria-describedby="basic-addon1" />
            </div>

            <div class="mb-3">
                <label class="form-label" for="text">End</label>
                <input class="form-control" name="dateend"  id="dateend" type="date"
                       aria-label="dateend" aria-describedby="basic-addon1" />
            </div>
            
            <div class="mb-3">
                <label class="form-label" for="text">Location</label>
                <input class="form-control" name="location"  id="location"
                       type="text" aria-label="location" aria-describedby="basic-addon1" />
            </div>

  

            <div class="mb-3">
                <label class="form-label" for="text">Tasks</label>
                <textarea class="form-control" name="tasks" id="tasks" placeholder="Write here..." rows="4"></textarea>                
            </div>

            <button class="btn btn-primary mt-2" type="submit">OK</button>
        </div>
    </form>

    <form action="index.php" method="Post" novalidate>
        <input type="hidden" name="owpn" value="$returnpage" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="myaction" value="" />
        
        <button class="btn btn-danger mt-2" type="submit">Close</button>
    </form>
</div>
ENDADDNEWFORM;
}

function displayEmpForm($position) : string
{
    global $owpn, $myprofile, $userid, $useraeskey, $returnpage;

    $company = htmlspecialchars($myprofile["Employment"][$position]["Company"]);
    $datestart = $myprofile["Employment"][$position]["DateStart"];
    $dateend = $myprofile["Employment"][$position]["DateEnd"];
    $location = htmlspecialchars($myprofile["Employment"][$position]["Location"]);
    $post = htmlspecialchars($myprofile["Employment"][$position]["Position"]);
    $tasks = htmlspecialchars($myprofile["Employment"][$position]["Tasks"]);
    $del = displayDelButton($position);
    $list = displayCurrent($position);

    if (isEmpty($myprofile["Employment"][$position]["Company"])) return "";
    
    return <<<ENDFORM
    <div class="mb-3">
    
        $list
        <div style="display: flex; flex-direction: row;">
            <a class="btn btn-sm btn-default mt-0 collapsed border" data-bs-toggle="collapse"
             href="#collapseEditEducation$position" role="button" aria-expanded="false"
             aria-controls="collapseEditEducation$position">Edit</a>
             $del
        </div>
           
        <form action="index.php" method="Post" novalidate>
        
            <input type="hidden" name="owpn" value="$owpn" />
            <input type="hidden" name="userid" value="$userid" />
            <input type="hidden" name="empposition" value="$position" />
            <input type="hidden" name="useraeskey" value="$useraeskey" />
            <input type="hidden" name="returnpage" value="$returnpage" />
            <input type="hidden" name="myaction" value="updateemployment" />
    
            <div class="collapse" id="collapseEditEducation$position">
                <div class="border p-card rounded mt-2">
                 
                    <div class="mb-3">
                        <label class="form-label" for="text">Company</label>
                        <input class="form-control" name="company"  id="company" type="text"
                            aria-label="company" aria-describedby="basic-addon1" value="$company"/>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label" for="text">Position</label>
                        <input class="form-control" name="position"  id="Position"
                            type="text" aria-label="Position" aria-describedby="basic-addon1" value="$post"/>
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="text">Start</label>
                        <input class="form-control" name="datestart"  id="datestart" type="date"
                            aria-label="datestart" aria-describedby="basic-addon1" value="$datestart"/>
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="text">End</label>
                        <input class="form-control" name="dateend"  id="dateend" type="date"
                            aria-label="dateend" aria-describedby="basic-addon1" value="$dateend"/>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label" for="text">Location</label>
                        <input class="form-control" name="location"  id="location"
                            type="text" aria-label="location" aria-describedby="basic-addon1"value="$location" />
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="text">Tasks</label>
                        <textarea class="form-control" name="tasks" id="tasks" placeholder="Write here..." rows="4">$tasks</textarea>                
                    </div>

                    <button class="btn btn-primary mt-2" type="submit">Save</button>
                    
                </div>
            </div>      
        </form>
    </div>
ENDFORM;
}

//**********************************************************
// Design
//**********************************************************
?>

<div class="col-md-6 p-0" style="display: <?php echo ($formVisible) ? "block" : "none"; ?>">
    <div class="card">
        <div class="card-header">
            <h4 class="m-0">Employment history</h4>
        </div>
        <div class="card-body bg-light pt-2">
            <p>If you have work experience, please list the companies you have worked for.</p>
            <?php
                $employment = $myprofile["Employment"];
                if (is_array($employment))
                foreach($employment as $position=>$value)
                {
                    echo displayEmpForm($position);
                }

                if ($myaction=="displayaddnew")
                {
                    echo displayAddNewForm();
                }
                else
                {
                    echo displayAddButton();
                }
            ?>
        </div>
    </div>
</div>