<?php

function createEducation() : array
{
    $edu["Institute"] = "";
    $edu["Qualification"] = "";
    $edu["Skills"] = "";
    $edu["DateStart"] = "";
    $edu["DateEnd"] = "";
    return $edu;
}

//**********************************************************
// Edit educational background
//**********************************************************
global $useraeskey,$returnpage,$userid,$myaction;
loadOptionalRequestParameters("useraeskey","returnpage","userid");
if (isEmpty($returnpage)) $returnpage = $page_profile_myprofile;

loadOrCreateProfile($userid,$myprofile,$error,$useraeskey);

$formVisible = true;
$resultVisible = false;

loadMyAction();
$position = -1;

if ($myaction=="deleducation")
{
    global $myprofile;

    $position = $_POST["postodel"];
    array_splice($myprofile["Education"], $position, 1);
    saveProfile($userid,$myprofile,$error,$useraeskey);
}

if ($myaction=="addeducation")
{
    global $myprofile;

    if (!is_array($myprofile["Education"])) $myprofile["Education"] = [];
    $position = count($myprofile["Education"]);
    $myprofile["Education"][$position] = createEducation();
    $myprofile["Education"][$position]["Institute"] = $_POST["institution"];
    $myprofile["Education"][$position]["Qualification"] = $_POST["qualification"];
    $myprofile["Education"][$position]["Skills"] = $_POST["skills_acquired"];
    $myprofile["Education"][$position]["DateStart"] = $_POST["datestart"];
    $myprofile["Education"][$position]["DateEnd"] = $_POST["dateend"];

    if (!isEmpty($myprofile["Education"][$position]["Institute"]) ||
        !isEmpty($myprofile["Education"][$position]["Qualification"]))
    {
        saveProfile($userid,$myprofile,$error,$useraeskey);
    }
}

if ($myaction=="updateeducation")
{
    if ($position==-1) $position = $_POST["eduposition"];
    $myprofile["Education"][$position]["Institute"] = $_POST["institution"];
    $myprofile["Education"][$position]["Qualification"] = $_POST["qualification"];
    $myprofile["Education"][$position]["Skills"] = $_POST["skills_acquired"];
    $myprofile["Education"][$position]["DateStart"] = $_POST["datestart"];
    $myprofile["Education"][$position]["DateEnd"] = $_POST["dateend"];

    if (!isEmpty($myprofile["Education"][$position]["Institute"]) ||
    !isEmpty($myprofile["Education"][$position]["Qualification"]))
    {
        saveProfile($userid,$myprofile,$error,$useraeskey);
    }
}

//**********************************************************
// Form components
//**********************************************************
function isEmptyInstitute($ed)
{
    if (
        isEmpty($ed["Qualification"]) && 
        isEmpty($ed["Institute"]) && 
        isEmpty($ed["Skills"])) return true;
    return false;
}

function displayDelButton($position) : string
{
    global $owpn, $userid, $useraeskey, $returnpage;

    return <<<ENDDELBUTTON
    <form action="index.php" method="post" novalidate>
        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="postodel" value="$position" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <input type="hidden" name="myaction" value="deleducation" />
        <button class="btn btn-sm btn-default mt-0 collapsed border" type="submit">Remove</button>
    </form>
ENDDELBUTTON;
}

function displayAddButton() : string
{
    global $owpn, $userid, $useraeskey, $returnpage;

    return <<<ENDADDBUTTON
    <form action="index.php" method="post" novalidate>
        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <input type="hidden" name="myaction" value="displayaddnew"/>
        <button class="btn btn-primary mt-2" type="submit">Add</button>
    </form>
ENDADDBUTTON;
}

function displayCurrent($position) : string
{
    global $owpn, $myprofile;
    $qualification=htmlspecialchars($myprofile["Education"][$position]["Qualification"]);
    $institute=htmlspecialchars($myprofile["Education"][$position]["Institute"]);
    $skills=htmlspecialchars($myprofile["Education"][$position]["Skills"]);
    $datestart=$myprofile["Education"][$position]["DateStart"];
    $dateend=$myprofile["Education"][$position]["DateEnd"];    

    $dateinterval = (isEmpty($datestart) && isEmpty($dateend)) ? "" : "<li>$datestart - $dateend</li>";

    return <<<ENDED
    <p class="mt-2 mb-1">
        <strong>$qualification</strong>
    </p>
    <ul style="list-style-type: none;">
        <li>$institute</li>
        $dateinterval
        <li>$skills</li>
    </ul>
ENDED;
}

function displayAddNewForm() : string
{
    global $myprofile, $owpn, $userid, $useraeskey, $returnpage;

    if(!is_array($myprofile["Education"]))
	    $position = 0;
    else
	    $position = count($myprofile["Education"]);

    return <<<ENDADDNEWFORM
<div>
    <form action="index.php" method="POST" novalidate>

        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <input type="hidden" name="myaction" value="addeducation" />

        <div class="border p-card rounded mt-2">

            <div class="mb-3">
                <label class="form-label" for="text">Institution</label>
                <input class="form-control" name="institution"  id="institution" type="text"
                       aria-label="edu_institution" aria-describedby="basic-addon1" />
            </div>

            <div class="mb-3">
                <label class="form-label" for="text">Qualification</label>
                <input class="form-control" name="qualification"  id="qualification"
                       type="text" aria-label="edu_qualification" aria-describedby="basic-addon1" />
            </div>

            <div class="mb-3">
                <label class="form-label" for="text">Start date</label>
                <input class="form-control" name="datestart"  id="datestart" type="date"
                       aria-label="edu_datestart" aria-describedby="basic-addon1" />
            </div>

            <div class="mb-3">
                <label class="form-label" for="text">End</label>
                <input class="form-control" name="dateend"  id="dateend" type="date"
                       aria-label="edu_dateend" aria-describedby="basic-addon1" />
            </div>

            <div class="mb-3">
                <label class="form-label" for="text">Skills acquired</label>
                <textarea class="form-control" name="skills_acquired" id="skills_acquired" placeholder="Write here..." rows="4"></textarea>                
            </div>

            <button class="btn btn-primary mt-2" type="submit">Add</button>
        </div>
    </form>

    <form action="index.php" method="post" novalidate>
        <input type="hidden" name="owpn" value="$returnpage" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="myaction" value="" />
        
        <button class="btn btn-danger mt-2" type="submit">Close</button>
    </form>
</div>
ENDADDNEWFORM;
}

function displayEduForm($position) 
{
    global $owpn, $myprofile, $userid, $useraeskey, $returnpage;

    $qualification=htmlspecialchars($myprofile["Education"][$position]["Qualification"]);
    $institute=htmlspecialchars($myprofile["Education"][$position]["Institute"]);
    $datestart=$myprofile["Education"][$position]["DateStart"];
    $dateend=$myprofile["Education"][$position]["DateEnd"];
    $skills=htmlspecialchars($myprofile["Education"][$position]["Skills"]);
    $del = displayDelButton($position);
    $list = displayCurrent($position);

    return <<<ENDFORM
    <div class="mb-3">
    
        $list
        <div style="display: flex; flex-direction: row;">
            <a class="btn btn-sm btn-default mt-0 collapsed border" data-bs-toggle="collapse"
             href="#collapseEditEducation$position" role="button" aria-expanded="false"
             aria-controls="collapseEditEducation$position">Edit</a>
             $del
        </div>
           
        <form action="index.php" method="post" novalidate>
        
            <input type="hidden" name="owpn" value="$owpn" />
            <input type="hidden" name="userid" value="$userid" />
            <input type="hidden" name="eduposition" value="$position" />
            <input type="hidden" name="useraeskey" value="$useraeskey" />
            <input type="hidden" name="returnpage" value="$returnpage" />
            <input type="hidden" name="myaction" value="updateeducation" />
    
            <div class="collapse" id="collapseEditEducation$position">
                <div class="border p-card rounded mt-2">
                 
                    <div class="mb-3">
                        <label class="form-label" for="text">Institution</label>
                        <input class="form-control" name="institution"  id="institution" type="text"
                         aria-label="edu_institution" aria-describedby="basic-addon1" value="$institute" />
                    </div>
    
                    <div class="mb-3">
                        <label class="form-label" for="text">Qualification</label>
                        <input class="form-control" name="qualification"  id="qualification"
                        type="text" aria-label="edu_qualification" aria-describedby="basic-addon1" value="$qualification" />
                    </div>
    
                    <div class="mb-3">
                        <label class="form-label" for="text">Training period start</label>
                        <input class="form-control" name="datestart"  id="datestart" type="date"
                         aria-label="edu_datestart" aria-describedby="basic-addon1" value="$datestart" />
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label" for="text">Training period end</label>
                        <input class="form-control" name="dateend"  id="dateend" type="date"
                         aria-label="edu_dateend" aria-describedby="basic-addon1" value="$dateend" />
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label" for="text">Skills acquired</label>
                        <textarea class="form-control" name="skills_acquired" id="skills_acquired" placeholder="Write here..." rows="4">$skills</textarea>  
                    </div>
                    
                    <button class="btn btn-primary mt-2" type="submit">Save</button>
                    
                </div>
            </div>      
        </form>
    </div>
ENDFORM;
}

//**********************************************************
// Design
//**********************************************************
?>

<div class="col-md-6 p-0" style="display: <?php echo ($formVisible) ? "block" : "none"; ?>">
    <div class="card">
        <div class="card-header">
            <h4 class="m-0">Edit educational background</h4>
        </div>
        <div class="card-body bg-light pt-2">
            <?php
                $education = $myprofile["Education"];
                if (is_array($education))
                foreach($education as $position=>$value)
                {
                    if (isEmptyInstitute($value)) continue;
                    echo displayEduForm($position);
                }

                if ($myaction=="displayaddnew")
                {
                    echo displayAddNewForm();
                }
                else
                {
                    echo displayAddButton();
                }
            ?>
        </div>
    </div>
</div>