<?php
//**************************************************************
// Edit contact
//**************************************************************

$emailError = "";
$backupEmailError = "";
$phoneError = "";
$backupPhoneError = "";

//**************************************************************
// Validators
//**************************************************************

function isvalidemail($myemail, &$error) : bool
{
    if (strlen($myemail)==0) return true;

    if (!filter_var($myemail, FILTER_VALIDATE_EMAIL))
    {
        $error = "This is not a valid E-mail address";
        return false;
    }
    return true;
}

function isthesameemail($email, $otheremail, &$error) : bool
{
    if (strlen($email)==0 || strlen($otheremail)==0) return true;

    if (strcmp($email, $otheremail) == 0)
    {
        $error = 'The backup email can not be the same';
        return false;
    }
    return true;
}

function isvalidphone($myphone, &$error) : bool
{
    if (strlen($myphone)==0) return true;

    if (!preg_match("/^(\+?)([0-9] ?){9,20}$/", $myphone))
    {
        $error = "This is not a valid phone number";
        return false;
    }
    return true;
}

function isthesamephone($phone, $otherphone, &$error) : bool
{
    if (strlen($phone)==0 || strlen($otherphone)==0) return true;

    if (strcmp($phone, $otherphone) == 0)
    {
        $error = 'The backup phone number can not be the same';
        return false;
    }
    return true;
}

//**************************************************************
// Edit social
//**************************************************************
global $useraeskey,$returnpage,$userid,$myaction;
loadOptionalRequestParameters("useraeskey","returnpage","userid");
if (isEmpty($returnpage)) $returnpage = $page_profile_myprofile;

loadOrCreateProfile($userid,$myprofile,$error,$useraeskey);

$formVisible = true;
$resultVisible = false;

loadMyAction();
if ($myaction=="updatecontact")
{
    $myemail = $_POST["myemail"];
    $mybackupemail = $_POST["mybackupemail"];
    $myphone = $_POST["myphone"];
    $mybackupphone = $_POST["mybackupphone"];
    
    $datavalid=true;
    if ($datavalid && !isvalidemail($myemail, $error))
    {
        $emailError = $error;
        $datavalid = false;
    }

    if ($datavalid && !isvalidemail($mybackupemail, $error))
    {
        $backupEmailError = $error;
        $datavalid = false;
    }

    if (!isthesameemail($myemail, $mybackupemail, $error))
    {
        $backupEmailError = $error;
        $datavalid = false;
    }

    if ($datavalid && !isvalidphone($myphone, $error))
    {
        $phoneError = $error;
        $datavalid = false;
    }

    if ($datavalid && !isvalidphone($mybackupphone, $error))
    {
        $backupPhoneError = $error;
        $datavalid = false;
    }

    if (!isthesamephone($myphone, $mybackupphone, $error))
    {
        $backupPhoneError = $error;
        $datavalid = false;
    }

    if ($datavalid)
    {
        $myprofile["Contact"]["Email"] = $myemail;
        $myprofile["Contact"]["BackupEmail"] = $mybackupemail;
        $myprofile["Contact"]["Mobile"] = $myphone;
        $myprofile["Contact"]["BackupMobile"] = $mybackupphone;

        if (!saveProfile($userid,$myprofile,$error,$useraeskey))
        {
            echo "Could not save profile $error";
            exit;
        }

        $formVisible = false;
        $resultVisible = true;
        $content = displaySuccess("Details updated successfully",null,"Go to profile",  $returnpage."&userid=$userid");
    }
}

?>

<?php
//**************************************************************
// Design
//**************************************************************
?>

<?php if ($resultVisible) echo $content; ?>
<div class="col-md-6 p-0" style="display: <?php echo ($formVisible) ? "block" : "none"; ?>">
    <div class="card">
        <div class="card-header">
            <h4 class="m-0">Edit contact details</h4>
        </div>
        <div class="card-body bg-light pt-2">
            <form enctype="multipart/form-data" action="index.php" method="POST" novalidate>
                <input type="hidden" name="owpn" value="<?php echo $owpn;?>">
                <input type="hidden" name="userid" value="<?php echo $userid;?>" />
                <input type="hidden" name="useraeskey" value="<?php echo $useraeskey;?>" />
                <input type="hidden" name="returnpage" value="<?php echo $returnpage;?>" />
                <input type="hidden" name="myaction" value="updatecontact">

                <!-- E-mail -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/at.svg" alt="at.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="myemail" type="text" placeholder="Email" aria-label="Email" aria-describedby="basic-addon1" value="<?php echo $myprofile["Contact"]["Email"]; ?>">
                </div>
                <div class="form-label mb-3 mt-0"  style="color:red; font-weight:bold"><?php echo $emailError;?></div>

                <!-- backup E-mail -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/at.svg" alt="at.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="mybackupemail" type="text" placeholder="Backup email" aria-label="Backup email" aria-describedby="basic-addon1" value="<?php echo $myprofile["Contact"]["BackupEmail"] ?? ""; ?>">
                </div>
                <div class="form-label mb-3 mt-0"  style="color:red; font-weight:bold"><?php echo $backupEmailError;?></div>

                <!-- Phone -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/phone.svg" alt="phone.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="myphone" type="text" placeholder="Phone" aria-label="Phone" aria-describedby="basic-addon1" value="<?php echo $myprofile["Contact"]["Mobile"]; ?>">
                </div>
                <div class="form-label mb-3 mt-0"  style="color:red; font-weight:bold"><?php echo $phoneError;?></div>

                <!-- Backup phone -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/phone.svg" alt="phone.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="mybackupphone" type="text" placeholder="Backup phone" aria-label="Backup phone" aria-describedby="basic-addon1" value="<?php echo $myprofile["Contact"]["BackupMobile"] ?? ""; ?>">
                </div>
                <div class="form-label mb-3 mt-0" style="color:red; font-weight:bold"><?php echo $backupPhoneError;?></div>

                <!-- OK -->
                <button class="btn btn-primary mt-2" type="submit" name="contact-submit">Submit</button>
            </form>
        </div>
    </div>
</div>
